-- Do not edit! Automatically created with doctest-extract from src/Data/List/Match/Private.hs
{-# LINE 15 "src/Data/List/Match/Private.hs" #-}

module DocTest.Data.List.Match.Private where

import Data.List.Match.Private
import Test.DocTest.Base
import qualified Test.DocTest.Driver as DocTest

{-# LINE 16 "src/Data/List/Match/Private.hs" #-}
import     qualified Data.List.Match.Private as Match
import     qualified Data.List as List
import     Data.Maybe (fromMaybe)

import     qualified Test.QuickCheck as QC
import     Test.QuickCheck ((===))

newtype     List = List [Integer] deriving (Show)
instance     QC.Arbitrary List where
       arbitrary = fmap List QC.arbitrary
       shrink (List xs) = map List $ QC.shrink xs

newtype     Shape = Shape [Ordering] deriving (Show)
instance     QC.Arbitrary Shape where
       arbitrary = fmap Shape QC.arbitrary
       shrink (Shape xs) = map Shape $ QC.shrink xs

test :: DocTest.T ()
test = do
 DocTest.printPrefix "Data.List.Match.Private:37: "
{-# LINE 37 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 37 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.take xs ys === List.take (length xs) ys
  )
 DocTest.printPrefix "Data.List.Match.Private:49: "
{-# LINE 49 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 49 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.drop xs ys === List.drop (length xs) ys
  )
 DocTest.printPrefix "Data.List.Match.Private:50: "
{-# LINE 50 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 50 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.take xs ys ++ Match.drop xs ys === ys
  )
 DocTest.printPrefix "Data.List.Match.Private:52: "
{-# LINE 52 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 52 "src/Data/List/Match/Private.hs" #-}
      \(List xs) (QC.NonEmpty ys) -> null $ Match.drop (xs++ys++undefined) xs
  )
 DocTest.printPrefix "Data.List.Match.Private:61: "
{-# LINE 61 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 61 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.drop xs ys === dropFoldl xs ys
  )
 DocTest.printPrefix "Data.List.Match.Private:73: "
{-# LINE 73 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 73 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.drop xs ys === dropRec xs ys
  )
 DocTest.printPrefix "Data.List.Match.Private:74: "
{-# LINE 74 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 74 "src/Data/List/Match/Private.hs" #-}
      \(List xs) ys -> null $ Match.dropRec (xs++ys++undefined) xs
  )
 DocTest.printPrefix "Data.List.Match.Private:81: "
{-# LINE 81 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 81 "src/Data/List/Match/Private.hs" #-}
           \(Shape xs) (List ys) -> Match.drop xs ys === drop0 xs ys
  )
 DocTest.printPrefix "Data.List.Match.Private:88: "
{-# LINE 88 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 88 "src/Data/List/Match/Private.hs" #-}
           \(Shape xs) (List ys) -> Match.drop xs ys === drop1 xs ys
  )
 DocTest.printPrefix "Data.List.Match.Private:93: "
{-# LINE 93 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 93 "src/Data/List/Match/Private.hs" #-}
           \(Shape xs) (List ys) -> Match.drop xs ys === drop2 xs ys
  )
 DocTest.printPrefix "Data.List.Match.Private:102: "
{-# LINE 102 "src/Data/List/Match/Private.hs" #-}
 DocTest.example(
{-# LINE 102 "src/Data/List/Match/Private.hs" #-}
    dropMaybe ([]::[Int]) "abc"
  )
  [ExpectedLine [LineChunk "Just \"abc\""]]
 DocTest.printPrefix "Data.List.Match.Private:105: "
{-# LINE 105 "src/Data/List/Match/Private.hs" #-}
 DocTest.example(
{-# LINE 105 "src/Data/List/Match/Private.hs" #-}
    dropMaybe [1,2::Int] "abc"
  )
  [ExpectedLine [LineChunk "Just \"c\""]]
 DocTest.printPrefix "Data.List.Match.Private:108: "
{-# LINE 108 "src/Data/List/Match/Private.hs" #-}
 DocTest.example(
{-# LINE 108 "src/Data/List/Match/Private.hs" #-}
    dropMaybe [1,2,3::Int] "abc"
  )
  [ExpectedLine [LineChunk "Just \"\""]]
 DocTest.printPrefix "Data.List.Match.Private:111: "
{-# LINE 111 "src/Data/List/Match/Private.hs" #-}
 DocTest.example(
{-# LINE 111 "src/Data/List/Match/Private.hs" #-}
    dropMaybe [1,2,3,4::Int] "abc"
  )
  [ExpectedLine [LineChunk "Nothing"]]
 DocTest.printPrefix "Data.List.Match.Private:114: "
{-# LINE 114 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 114 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.drop xs ys === fromMaybe [] (Match.dropMaybe xs ys)
  )
 DocTest.printPrefix "Data.List.Match.Private:124: "
{-# LINE 124 "src/Data/List/Match/Private.hs" #-}
 DocTest.example(
{-# LINE 124 "src/Data/List/Match/Private.hs" #-}
    laxTail ""
  )
  [ExpectedLine [LineChunk "\"\""]]
 DocTest.printPrefix "Data.List.Match.Private:126: "
{-# LINE 126 "src/Data/List/Match/Private.hs" #-}
 DocTest.example(
{-# LINE 126 "src/Data/List/Match/Private.hs" #-}
    laxTail "a"
  )
  [ExpectedLine [LineChunk "\"\""]]
 DocTest.printPrefix "Data.List.Match.Private:128: "
{-# LINE 128 "src/Data/List/Match/Private.hs" #-}
 DocTest.example(
{-# LINE 128 "src/Data/List/Match/Private.hs" #-}
    laxTail "ab"
  )
  [ExpectedLine [LineChunk "\"b\""]]
 DocTest.printPrefix "Data.List.Match.Private:134: "
{-# LINE 134 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 134 "src/Data/List/Match/Private.hs" #-}
           \(List xs) -> Match.laxTail xs === Match.laxTail0 xs
  )
 DocTest.printPrefix "Data.List.Match.Private:139: "
{-# LINE 139 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 139 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.splitAt xs ys === (Match.take xs ys, Match.drop xs ys)
  )
 DocTest.printPrefix "Data.List.Match.Private:140: "
{-# LINE 140 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 140 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.splitAt xs ys === List.splitAt (length xs) ys
  )
 DocTest.printPrefix "Data.List.Match.Private:142: "
{-# LINE 142 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 142 "src/Data/List/Match/Private.hs" #-}
      \(List xs) (QC.NonEmpty ys) -> null $ snd $ Match.splitAt (xs++ys++undefined) xs
  )
 DocTest.printPrefix "Data.List.Match.Private:151: "
{-# LINE 151 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 151 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.splitAt xs ys === Match.splitAtRec xs ys
  )
 DocTest.printPrefix "Data.List.Match.Private:161: "
{-# LINE 161 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 161 "src/Data/List/Match/Private.hs" #-}
           \(Shape xs) (List ys) -> Match.takeRev xs ys === reverse (Match.take xs (reverse ys))
  )
 DocTest.printPrefix "Data.List.Match.Private:165: "
{-# LINE 165 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 165 "src/Data/List/Match/Private.hs" #-}
           \(Shape xs) (List ys) -> Match.dropRev xs ys === reverse (Match.drop xs (reverse ys))
  )
 DocTest.printPrefix "Data.List.Match.Private:173: "
{-# LINE 173 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 173 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> equalLength xs ys === (length xs == length ys)
  )
 DocTest.printPrefix "Data.List.Match.Private:185: "
{-# LINE 185 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 185 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> compareLength xs ys === compare (length xs) (length ys)
  )
 DocTest.printPrefix "Data.List.Match.Private:195: "
{-# LINE 195 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 195 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.compareLength xs ys === Match.compareLength0 xs ys
  )
 DocTest.printPrefix "Data.List.Match.Private:207: "
{-# LINE 207 "src/Data/List/Match/Private.hs" #-}
 DocTest.property(
{-# LINE 207 "src/Data/List/Match/Private.hs" #-}
      \(Shape xs) (List ys) -> Match.compareLength xs ys === Match.compareLength1 xs ys
  )
 DocTest.printPrefix "Data.List.Match.Private:217: "
{-# LINE 217 "src/Data/List/Match/Private.hs" #-}
 DocTest.example(
{-# LINE 217 "src/Data/List/Match/Private.hs" #-}
    lessOrEqualLength "" undefined
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.Match.Private:232: "
{-# LINE 232 "src/Data/List/Match/Private.hs" #-}
 DocTest.example(
{-# LINE 232 "src/Data/List/Match/Private.hs" #-}
    shorterList (shorterList (repeat 'a') (repeat 'b')) "abc"
  )
  [ExpectedLine [LineChunk "\"abc\""]]
 DocTest.printPrefix "Data.List.Match.Private:251: "
{-# LINE 251 "src/Data/List/Match/Private.hs" #-}
 DocTest.example(
{-# LINE 251 "src/Data/List/Match/Private.hs" #-}
    List.take 3 $ shorterListEq ("abc" ++ repeat 'a') ("abcdef" ++ repeat 'b')
  )
  [ExpectedLine [LineChunk "\"abc\""]]
