-- Do not edit! Automatically created with doctest-extract from src/Data/List/HT/Private.hs
{-# LINE 21 "src/Data/List/HT/Private.hs" #-}

module DocTest.Data.List.HT.Private where

import Data.List.HT.Private
import Test.DocTest.Base
import qualified Test.DocTest.Driver as DocTest

{-# LINE 22 "src/Data/List/HT/Private.hs" #-}
import     qualified Test.QuickCheck as QC
import     Test.QuickCheck ((===))
import     Test.Utility (forAllPredicates)
import     Test.QuickCheck (NonNegative(NonNegative), Positive(Positive), NonEmptyList(NonEmpty))
import     qualified Data.List.Match as Match
import     qualified Data.List as List
import     Data.List (transpose)
import     Data.Maybe.HT (toMaybe)
import     Data.Maybe (mapMaybe, isNothing)
import     Data.Char (isLetter, isUpper, toUpper)
import     Data.Eq.HT (equating)
import     Control.Monad (liftM2)

import     Prelude hiding (span)

divMaybe     :: Int -> Int -> Maybe Int
divMaybe     m n = case divMod n m of (q,0) -> Just q; _ -> Nothing

forAllMaybeFn     :: (QC.Testable test) => ((Int -> Maybe Int) -> test) -> QC.Property
forAllMaybeFn     prop = QC.forAll (QC.choose (1,4)) $ prop . divMaybe

test :: DocTest.T ()
test = do
 DocTest.printPrefix "Data.List.HT.Private:52: "
{-# LINE 52 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 52 "src/Data/List/HT/Private.hs" #-}
    head $ inits (undefined :: String)
  )
  [ExpectedLine [LineChunk "\"\""]]
 DocTest.printPrefix "Data.List.HT.Private:90: "
{-# LINE 90 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 90 "src/Data/List/HT/Private.hs" #-}
    null $ tails (undefined :: String)
  )
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:101: "
{-# LINE 101 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 101 "src/Data/List/HT/Private.hs" #-}
      \xs -> tails xs === tailsIterate (xs :: [Int])
  )
 DocTest.printPrefix "Data.List.HT.Private:116: "
{-# LINE 116 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 116 "src/Data/List/HT/Private.hs" #-}
    nonEmptyTails [1,2,3::Int]
  )
  [ExpectedLine [LineChunk "[(1,[2,3]),(2,[3]),(3,[])]"]]
 DocTest.printPrefix "Data.List.HT.Private:119: "
{-# LINE 119 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 119 "src/Data/List/HT/Private.hs" #-}
      \xs -> tails xs === map (uncurry (:)) (nonEmptyTails xs) ++ [[]::[Int]]
  )
 DocTest.printPrefix "Data.List.HT.Private:133: "
{-# LINE 133 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 133 "src/Data/List/HT/Private.hs" #-}
    groupBy (<) "abcdebcdef"
  )
  [ExpectedLine [LineChunk "[\"abcde\",\"bcdef\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:140: "
{-# LINE 140 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 140 "src/Data/List/HT/Private.hs" #-}
    List.groupBy (<) "abcdebcdef"
  )
  [ExpectedLine [LineChunk "[\"abcdebcdef\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:153: "
{-# LINE 153 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 153 "src/Data/List/HT/Private.hs" #-}
    head $ group ("aabcdef"++repeat 'g')
  )
  [ExpectedLine [LineChunk "\"aa\""]]
 DocTest.printPrefix "Data.List.HT.Private:156: "
{-# LINE 156 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 156 "src/Data/List/HT/Private.hs" #-}
    take 10 $ group ("aabcdef"++cycle "gh")
  )
  [ExpectedLine [LineChunk "[\"aa\",\"b\",\"c\",\"d\",\"e\",\"f\",\"g\",\"h\",\"g\",\"h\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:196: "
{-# LINE 196 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 196 "src/Data/List/HT/Private.hs" #-}
    case span (>0) (undefined :: [Int]) of (_,_) -> "defined"
  )
  [ExpectedLine [LineChunk "\"defined\""]]
 DocTest.printPrefix "Data.List.HT.Private:209: "
{-# LINE 209 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 209 "src/Data/List/HT/Private.hs" #-}
      \xs -> span (>0) xs === spanCase (>0) (xs::[Int])
  )
 DocTest.printPrefix "Data.List.HT.Private:232: "
{-# LINE 232 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 232 "src/Data/List/HT/Private.hs" #-}
    words "a  a"
  )
  [ExpectedLine [LineChunk "[\"a\",\"a\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:234: "
{-# LINE 234 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 234 "src/Data/List/HT/Private.hs" #-}
    chop (' '==) "a  a"
  )
  [ExpectedLine [LineChunk "[\"a\",\"\",\"a\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:237: "
{-# LINE 237 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 237 "src/Data/List/HT/Private.hs" #-}
    lines "a\n\na"
  )
  [ExpectedLine [LineChunk "[\"a\",\"\",\"a\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:239: "
{-# LINE 239 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 239 "src/Data/List/HT/Private.hs" #-}
    chop ('\n'==) "a\n\na"
  )
  [ExpectedLine [LineChunk "[\"a\",\"\",\"a\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:242: "
{-# LINE 242 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 242 "src/Data/List/HT/Private.hs" #-}
    lines "a\n"
  )
  [ExpectedLine [LineChunk "[\"a\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:244: "
{-# LINE 244 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 244 "src/Data/List/HT/Private.hs" #-}
    chop ('\n'==) "a\n"
  )
  [ExpectedLine [LineChunk "[\"a\",\"\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:271: "
{-# LINE 271 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 271 "src/Data/List/HT/Private.hs" #-}
    chopNothing ([] :: [Maybe String])
  )
  [ExpectedLine [LineChunk "[[]]"]]
 DocTest.printPrefix "Data.List.HT.Private:274: "
{-# LINE 274 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 274 "src/Data/List/HT/Private.hs" #-}
    chopNothing [Nothing :: Maybe String]
  )
  [ExpectedLine [LineChunk "[[],[]]"]]
 DocTest.printPrefix "Data.List.HT.Private:277: "
{-# LINE 277 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 277 "src/Data/List/HT/Private.hs" #-}
    chopNothing [Just "a", Just "b", Nothing, Just "c", Nothing, Just "d", Just "e"]
  )
  [ExpectedLine [LineChunk "[[\"a\",\"b\"],[\"c\"],[\"d\",\"e\"]]"]]
 DocTest.printPrefix "Data.List.HT.Private:280: "
{-# LINE 280 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 280 "src/Data/List/HT/Private.hs" #-}
      \xs ys -> chopNothing (xs ++ Nothing : ys) === chopNothing xs ++ chopNothing (ys :: [Maybe Int])
  )
 DocTest.printPrefix "Data.List.HT.Private:282: "
{-# LINE 282 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 282 "src/Data/List/HT/Private.hs" #-}
      \ns xs -> equating (Match.take (ns::[()])) (cycle (chopNothing xs)) (chopNothing (cycle (xs ++ [Nothing :: Maybe Int])))
  )
 DocTest.printPrefix "Data.List.HT.Private:309: "
{-# LINE 309 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 309 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p xs -> uncurry (++) (breakAfter p xs) === xs
  )
 DocTest.printPrefix "Data.List.HT.Private:328: "
{-# LINE 328 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 328 "src/Data/List/HT/Private.hs" #-}
           forAllPredicates $ \p xs -> breakAfterRec p xs === breakAfterFoldr p xs
  )
 DocTest.printPrefix "Data.List.HT.Private:336: "
{-# LINE 336 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 336 "src/Data/List/HT/Private.hs" #-}
           forAllPredicates $ \p xs -> breakAfterRec p xs === breakAfterBreak p xs
  )
 DocTest.printPrefix "Data.List.HT.Private:343: "
{-# LINE 343 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 343 "src/Data/List/HT/Private.hs" #-}
           forAllPredicates $ \p xs -> breakAfterRec p xs === breakAfterTakeUntil p xs
  )
 DocTest.printPrefix "Data.List.HT.Private:356: "
{-# LINE 356 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 356 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p xs -> takeUntil p xs === fst (breakAfter p xs)
  )
 DocTest.printPrefix "Data.List.HT.Private:369: "
{-# LINE 369 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 369 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p xs -> concat (segmentAfter p xs) === xs
  )
 DocTest.printPrefix "Data.List.HT.Private:370: "
{-# LINE 370 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 370 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p xs -> length (filter p xs) === length (tail (segmentAfter p xs))
  )
 DocTest.printPrefix "Data.List.HT.Private:371: "
{-# LINE 371 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 371 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p -> all (p . last) . init . segmentAfter p
  )
 DocTest.printPrefix "Data.List.HT.Private:372: "
{-# LINE 372 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 372 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p -> all (all (not . p) . init) . init . segmentAfter p
  )
 DocTest.printPrefix "Data.List.HT.Private:376: "
{-# LINE 376 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 376 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p x -> flip seq True . (!!100) . concat . segmentAfter p . cycle . (x:)
  )
 DocTest.printPrefix "Data.List.HT.Private:398: "
{-# LINE 398 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 398 "src/Data/List/HT/Private.hs" #-}
    segmentBefore isUpper "AbcdXyz"
  )
  [ExpectedLine [LineChunk "[\"\",\"Abcd\",\"Xyz\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:400: "
{-# LINE 400 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 400 "src/Data/List/HT/Private.hs" #-}
    segmentBefore isUpper "kAbcdXYZ"
  )
  [ExpectedLine [LineChunk "[\"k\",\"Abcd\",\"X\",\"Y\",\"Z\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:403: "
{-# LINE 403 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 403 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p xs -> concat (segmentBefore p xs) === xs
  )
 DocTest.printPrefix "Data.List.HT.Private:404: "
{-# LINE 404 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 404 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p xs -> length (filter p xs) === length (tail (segmentBefore p xs))
  )
 DocTest.printPrefix "Data.List.HT.Private:405: "
{-# LINE 405 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 405 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p -> all (p . head) . tail . segmentBefore p
  )
 DocTest.printPrefix "Data.List.HT.Private:406: "
{-# LINE 406 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 406 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p -> all (all (not . p) . tail) . tail . segmentBefore p
  )
 DocTest.printPrefix "Data.List.HT.Private:407: "
{-# LINE 407 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 407 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p x -> flip seq True . (!!100) . concat . segmentBefore p . cycle . (x:)
  )
 DocTest.printPrefix "Data.List.HT.Private:419: "
{-# LINE 419 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 419 "src/Data/List/HT/Private.hs" #-}
           forAllPredicates $ \p xs -> segmentBefore p xs === segmentBefore' p xs
  )
 DocTest.printPrefix "Data.List.HT.Private:430: "
{-# LINE 430 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 430 "src/Data/List/HT/Private.hs" #-}
           forAllPredicates $ \p xs -> segmentBefore p xs === segmentBefore'' p xs
  )
 DocTest.printPrefix "Data.List.HT.Private:442: "
{-# LINE 442 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 442 "src/Data/List/HT/Private.hs" #-}
    segmentBeforeJust (\c -> toMaybe (isLetter c) (toUpper c)) "123a5345b---"
  )
  [ExpectedLine [LineChunk "(\"123\",[('A',\"5345\"),('B',\"---\")])"]]
 DocTest.printPrefix "Data.List.HT.Private:458: "
{-# LINE 458 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 458 "src/Data/List/HT/Private.hs" #-}
    segmentAfterJust (\c -> toMaybe (isLetter c) (toUpper c)) "123a5345b---"
  )
  [ExpectedLine [LineChunk "([(\"123\",'A'),(\"5345\",'B')],\"---\")"]]
 DocTest.printPrefix "Data.List.HT.Private:471: "
{-# LINE 471 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 471 "src/Data/List/HT/Private.hs" #-}
    segmentBeforeRight [Left 'a', Right LT, Right GT, Left 'b']
  )
  [ExpectedLine [LineChunk "(\"a\",[(LT,\"\"),(GT,\"b\")])"]]
 DocTest.printPrefix "Data.List.HT.Private:474: "
{-# LINE 474 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 474 "src/Data/List/HT/Private.hs" #-}
      forAllMaybeFn $ \f xs -> segmentBeforeJust f xs === segmentBeforeRight (map (\x -> maybe (Left x) Right (f x)) xs)
  )
 DocTest.printPrefix "Data.List.HT.Private:488: "
{-# LINE 488 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 488 "src/Data/List/HT/Private.hs" #-}
    segmentAfterRight [Left 'a', Right LT, Right GT, Left 'b']
  )
  [ExpectedLine [LineChunk "([(\"a\",LT),(\"\",GT)],\"b\")"]]
 DocTest.printPrefix "Data.List.HT.Private:491: "
{-# LINE 491 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 491 "src/Data/List/HT/Private.hs" #-}
      forAllMaybeFn $ \f xs -> segmentAfterJust f xs === segmentAfterRight (map (\x -> maybe (Left x) Right (f x)) xs)
  )
 DocTest.printPrefix "Data.List.HT.Private:514: "
{-# LINE 514 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 514 "src/Data/List/HT/Private.hs" #-}
    removeEach "abc"
  )
  [ExpectedLine [LineChunk "[('a',\"bc\"),('b',\"ac\"),('c',\"ab\")]"]]
 DocTest.printPrefix "Data.List.HT.Private:516: "
{-# LINE 516 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 516 "src/Data/List/HT/Private.hs" #-}
    removeEach "a"
  )
  [ExpectedLine [LineChunk "[('a',\"\")]"]]
 DocTest.printPrefix "Data.List.HT.Private:518: "
{-# LINE 518 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 518 "src/Data/List/HT/Private.hs" #-}
    removeEach ""
  )
  [ExpectedLine [LineChunk "[]"]]
 DocTest.printPrefix "Data.List.HT.Private:526: "
{-# LINE 526 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 526 "src/Data/List/HT/Private.hs" #-}
    splitEverywhere "abc"
  )
  [ExpectedLine [LineChunk "[(\"\",'a',\"bc\"),(\"a\",'b',\"c\"),(\"ab\",'c',\"\")]"]]
 DocTest.printPrefix "Data.List.HT.Private:528: "
{-# LINE 528 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 528 "src/Data/List/HT/Private.hs" #-}
    splitEverywhere "a"
  )
  [ExpectedLine [LineChunk "[(\"\",'a',\"\")]"]]
 DocTest.printPrefix "Data.List.HT.Private:530: "
{-# LINE 530 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 530 "src/Data/List/HT/Private.hs" #-}
    splitEverywhere ""
  )
  [ExpectedLine [LineChunk "[]"]]
 DocTest.printPrefix "Data.List.HT.Private:549: "
{-# LINE 549 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 549 "src/Data/List/HT/Private.hs" #-}
      \(NonEmpty xs) -> splitLast (xs::String)  ===  (init xs, last xs)
  )
 DocTest.printPrefix "Data.List.HT.Private:569: "
{-# LINE 569 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 569 "src/Data/List/HT/Private.hs" #-}
      \xs -> maybe True ((init xs, last xs) == ) (viewR (xs::String))
  )
 DocTest.printPrefix "Data.List.HT.Private:590: "
{-# LINE 590 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 590 "src/Data/List/HT/Private.hs" #-}
      \xs -> switchR True (\ixs lxs -> ixs == init xs && lxs == last xs) (xs::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:604: "
{-# LINE 604 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 604 "src/Data/List/HT/Private.hs" #-}
      \n xs -> takeRev n (xs::String) === reverse (take n (reverse xs))
  )
 DocTest.printPrefix "Data.List.HT.Private:613: "
{-# LINE 613 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 613 "src/Data/List/HT/Private.hs" #-}
      \n xs -> dropRev n (xs::String) === reverse (drop n (reverse xs))
  )
 DocTest.printPrefix "Data.List.HT.Private:621: "
{-# LINE 621 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 621 "src/Data/List/HT/Private.hs" #-}
      \n xs -> splitAtRev n (xs::String) === (dropRev n xs, takeRev n xs)
  )
 DocTest.printPrefix "Data.List.HT.Private:622: "
{-# LINE 622 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 622 "src/Data/List/HT/Private.hs" #-}
      \n xs -> (xs::String) === uncurry (++) (splitAtRev n xs)
  )
 DocTest.printPrefix "Data.List.HT.Private:636: "
{-# LINE 636 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 636 "src/Data/List/HT/Private.hs" #-}
    maybePrefixOf "abc" "abcdef"
  )
  [ExpectedLine [LineChunk "Just \"def\""]]
 DocTest.printPrefix "Data.List.HT.Private:638: "
{-# LINE 638 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 638 "src/Data/List/HT/Private.hs" #-}
    maybePrefixOf "def" "abcdef"
  )
  [ExpectedLine [LineChunk "Nothing"]]
 DocTest.printPrefix "Data.List.HT.Private:647: "
{-# LINE 647 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 647 "src/Data/List/HT/Private.hs" #-}
    maybeSuffixOf "abc" "abcdef"
  )
  [ExpectedLine [LineChunk "Nothing"]]
 DocTest.printPrefix "Data.List.HT.Private:649: "
{-# LINE 649 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 649 "src/Data/List/HT/Private.hs" #-}
    maybeSuffixOf "def" "abcdef"
  )
  [ExpectedLine [LineChunk "Just \"abc\""]]
 DocTest.printPrefix "Data.List.HT.Private:652: "
{-# LINE 652 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 652 "src/Data/List/HT/Private.hs" #-}
      \xs ys -> maybeSuffixOf xs ys === fmap reverse (maybePrefixOf (reverse xs) (reverse (ys::[Ordering])))
  )
 DocTest.printPrefix "Data.List.HT.Private:667: "
{-# LINE 667 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 667 "src/Data/List/HT/Private.hs" #-}
      forAllMaybeFn $ \f xs -> partitionMaybe f xs === (mapMaybe f xs, filter (isNothing . f) xs)
  )
 DocTest.printPrefix "Data.List.HT.Private:668: "
{-# LINE 668 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 668 "src/Data/List/HT/Private.hs" #-}
      forAllPredicates $ \p xs -> partition p xs === partitionMaybe (\x -> toMaybe (p x) x) xs
  )
 DocTest.printPrefix "Data.List.HT.Private:681: "
{-# LINE 681 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 681 "src/Data/List/HT/Private.hs" #-}
    takeWhileJust [Just 'a', Just 'b', Nothing, Just 'c']
  )
  [ExpectedLine [LineChunk "\"ab\""]]
 DocTest.printPrefix "Data.List.HT.Private:686: "
{-# LINE 686 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 686 "src/Data/List/HT/Private.hs" #-}
    takeWhileJust $ map (fmap fst . viewL) ["abc","def","","xyz"]
  )
  [ExpectedLine [LineChunk "\"ad\""]]
 DocTest.printPrefix "Data.List.HT.Private:707: "
{-# LINE 707 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 707 "src/Data/List/HT/Private.hs" #-}
           forAllMaybeFn $ \f xs -> dropWhileNothing f xs === dropWhileNothingRec f xs
  )
 DocTest.printPrefix "Data.List.HT.Private:714: "
{-# LINE 714 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 714 "src/Data/List/HT/Private.hs" #-}
           forAllMaybeFn $ \f xs -> snd (breakJust f xs) === dropWhileNothing f xs
  )
 DocTest.printPrefix "Data.List.HT.Private:725: "
{-# LINE 725 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 725 "src/Data/List/HT/Private.hs" #-}
           forAllMaybeFn $ \f xs -> breakJust f xs === breakJustRemoveEach f xs
  )
 DocTest.printPrefix "Data.List.HT.Private:733: "
{-# LINE 733 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 733 "src/Data/List/HT/Private.hs" #-}
           forAllMaybeFn $ \f xs -> breakJust f xs === breakJustPartial f xs
  )
 DocTest.printPrefix "Data.List.HT.Private:761: "
{-# LINE 761 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 761 "src/Data/List/HT/Private.hs" #-}
    sieve 6 ['a'..'z']
  )
  [ExpectedLine [LineChunk "\"agmsy\""]]
 DocTest.printPrefix "Data.List.HT.Private:768: "
{-# LINE 768 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 768 "src/Data/List/HT/Private.hs" #-}
           \(Positive n) xs -> sieve n xs === sieve' n (xs::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:771: "
{-# LINE 771 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 771 "src/Data/List/HT/Private.hs" #-}
           \(Positive n) xs -> sieve n xs === sieve'' n (xs::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:774: "
{-# LINE 774 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 774 "src/Data/List/HT/Private.hs" #-}
           \(Positive n) xs -> sieve n xs === sieve''' n (xs::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:783: "
{-# LINE 783 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 783 "src/Data/List/HT/Private.hs" #-}
    sliceHorizontal 6 ['a'..'z']
  )
  [ExpectedLine [LineChunk "[\"agmsy\",\"bhntz\",\"ciou\",\"djpv\",\"ekqw\",\"flrx\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:786: "
{-# LINE 786 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 786 "src/Data/List/HT/Private.hs" #-}
      \(NonEmpty xs) -> QC.forAll (QC.choose (1, length xs)) $ \n -> sliceHorizontal n xs === transpose (sliceVertical n (xs::String))
  )
 DocTest.printPrefix "Data.List.HT.Private:787: "
{-# LINE 787 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 787 "src/Data/List/HT/Private.hs" #-}
      \(NonEmpty xs) -> QC.forAll (QC.choose (1, length xs)) $ \n -> sliceVertical  n xs === transpose (sliceHorizontal n (xs::String))
  )
 DocTest.printPrefix "Data.List.HT.Private:791: "
{-# LINE 791 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 791 "src/Data/List/HT/Private.hs" #-}
    sliceHorizontal 4 ([]::[Int])
  )
  [ExpectedLine [LineChunk "[[],[],[],[]]"]]
 DocTest.printPrefix "Data.List.HT.Private:799: "
{-# LINE 799 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 799 "src/Data/List/HT/Private.hs" #-}
           \(NonNegative n) xs -> sliceHorizontal n xs === sliceHorizontal' n (xs::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:803: "
{-# LINE 803 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 803 "src/Data/List/HT/Private.hs" #-}
           \(Positive n) xs -> sliceHorizontal n xs === sliceHorizontal'' n (xs::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:812: "
{-# LINE 812 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 812 "src/Data/List/HT/Private.hs" #-}
    sliceVertical 6 ['a'..'z']
  )
  [ExpectedLine [LineChunk "[\"abcdef\",\"ghijkl\",\"mnopqr\",\"stuvwx\",\"yz\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:821: "
{-# LINE 821 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 821 "src/Data/List/HT/Private.hs" #-}
           \(NonNegative n) xs -> equating (take 100000) (sliceVertical n xs) (sliceVertical' n (xs::String))
  )
 DocTest.printPrefix "Data.List.HT.Private:834: "
{-# LINE 834 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 834 "src/Data/List/HT/Private.hs" #-}
      \(NonEmpty xs) ys -> replace xs xs ys === (ys::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:835: "
{-# LINE 835 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 835 "src/Data/List/HT/Private.hs" #-}
      \(NonEmpty xs) (NonEmpty ys) -> equating (take 1000) (replace xs ys (cycle xs)) (cycle (ys::String))
  )
 DocTest.printPrefix "Data.List.HT.Private:973: "
{-# LINE 973 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 973 "src/Data/List/HT/Private.hs" #-}
      \xs -> shearTranspose xs  ===  map reverse (shear (xs::[String]))
  )
 DocTest.printPrefix "Data.List.HT.Private:1008: "
{-# LINE 1008 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1008 "src/Data/List/HT/Private.hs" #-}
      \xs ys -> let f x y = (x::Char,y::Int) in concat (outerProduct f xs ys)  ===  liftM2 f xs ys
  )
 DocTest.printPrefix "Data.List.HT.Private:1031: "
{-# LINE 1031 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1031 "src/Data/List/HT/Private.hs" #-}
      \ys xs -> let ps = map (<=) ys in takeWhileMulti ps xs === takeWhileMulti' ps (xs::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:1085: "
{-# LINE 1085 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1085 "src/Data/List/HT/Private.hs" #-}
    lengthAtLeast 0 ""
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1087: "
{-# LINE 1087 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1087 "src/Data/List/HT/Private.hs" #-}
    lengthAtLeast 3 "ab"
  )
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1089: "
{-# LINE 1089 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1089 "src/Data/List/HT/Private.hs" #-}
    lengthAtLeast 3 "abc"
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1091: "
{-# LINE 1091 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1091 "src/Data/List/HT/Private.hs" #-}
    lengthAtLeast 3 $ repeat 'a'
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1093: "
{-# LINE 1093 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1093 "src/Data/List/HT/Private.hs" #-}
    lengthAtLeast 3 $ "abc" ++ undefined
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1096: "
{-# LINE 1096 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1096 "src/Data/List/HT/Private.hs" #-}
      \n xs -> lengthAtLeast n (xs::String)  ===  (length xs >= n)
  )
 DocTest.printPrefix "Data.List.HT.Private:1105: "
{-# LINE 1105 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1105 "src/Data/List/HT/Private.hs" #-}
    lengthAtMost 0 ""
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1107: "
{-# LINE 1107 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1107 "src/Data/List/HT/Private.hs" #-}
    lengthAtMost 3 "ab"
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1109: "
{-# LINE 1109 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1109 "src/Data/List/HT/Private.hs" #-}
    lengthAtMost 3 "abc"
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1111: "
{-# LINE 1111 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1111 "src/Data/List/HT/Private.hs" #-}
    lengthAtMost 3 "abcd"
  )
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1113: "
{-# LINE 1113 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1113 "src/Data/List/HT/Private.hs" #-}
    lengthAtMost 3 $ repeat 'a'
  )
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1115: "
{-# LINE 1115 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1115 "src/Data/List/HT/Private.hs" #-}
    lengthAtMost 3 $ "abcd" ++ undefined
  )
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1118: "
{-# LINE 1118 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1118 "src/Data/List/HT/Private.hs" #-}
      \n xs -> lengthAtMost n (xs::String)  ===  (length xs <= n)
  )
 DocTest.printPrefix "Data.List.HT.Private:1127: "
{-# LINE 1127 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1127 "src/Data/List/HT/Private.hs" #-}
      \n xs -> lengthAtMost0 n (xs::String)  ===  (length xs <= n)
  )
 DocTest.printPrefix "Data.List.HT.Private:1174: "
{-# LINE 1174 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1174 "src/Data/List/HT/Private.hs" #-}
      \n (NonEmpty xs) -> rotate n xs === rotate' n (xs::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:1181: "
{-# LINE 1181 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1181 "src/Data/List/HT/Private.hs" #-}
      \(NonNegative n) xs -> rotate n xs === rotate'' n (xs::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:1191: "
{-# LINE 1191 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1191 "src/Data/List/HT/Private.hs" #-}
    mergeBy (<=) "agh" "begz"
  )
  [ExpectedLine [LineChunk "\"abegghz\""]]
 DocTest.printPrefix "Data.List.HT.Private:1199: "
{-# LINE 1199 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1199 "src/Data/List/HT/Private.hs" #-}
    allEqual "aab"
  )
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1201: "
{-# LINE 1201 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1201 "src/Data/List/HT/Private.hs" #-}
    allEqual "aaa"
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1203: "
{-# LINE 1203 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1203 "src/Data/List/HT/Private.hs" #-}
    allEqual "aa"
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1205: "
{-# LINE 1205 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1205 "src/Data/List/HT/Private.hs" #-}
    allEqual "a"
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1207: "
{-# LINE 1207 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1207 "src/Data/List/HT/Private.hs" #-}
    allEqual ""
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1214: "
{-# LINE 1214 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1214 "src/Data/List/HT/Private.hs" #-}
    isAscending "abc"
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1216: "
{-# LINE 1216 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1216 "src/Data/List/HT/Private.hs" #-}
    isAscending "abb"
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1218: "
{-# LINE 1218 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1218 "src/Data/List/HT/Private.hs" #-}
    isAscending "aba"
  )
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1220: "
{-# LINE 1220 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1220 "src/Data/List/HT/Private.hs" #-}
    isAscending "cba"
  )
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1222: "
{-# LINE 1222 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1222 "src/Data/List/HT/Private.hs" #-}
    isAscending "a"
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1224: "
{-# LINE 1224 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1224 "src/Data/List/HT/Private.hs" #-}
    isAscending ""
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1237: "
{-# LINE 1237 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1237 "src/Data/List/HT/Private.hs" #-}
    mapAdjacent (<=) ""
  )
  [ExpectedLine [LineChunk "[]"]]
 DocTest.printPrefix "Data.List.HT.Private:1239: "
{-# LINE 1239 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1239 "src/Data/List/HT/Private.hs" #-}
    mapAdjacent (<=) "a"
  )
  [ExpectedLine [LineChunk "[]"]]
 DocTest.printPrefix "Data.List.HT.Private:1241: "
{-# LINE 1241 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1241 "src/Data/List/HT/Private.hs" #-}
    mapAdjacent (<=) "aba"
  )
  [ExpectedLine [LineChunk "[True,False]"]]
 DocTest.printPrefix "Data.List.HT.Private:1243: "
{-# LINE 1243 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1243 "src/Data/List/HT/Private.hs" #-}
    mapAdjacent (,) "abc"
  )
  [ExpectedLine [LineChunk "[('a','b'),('b','c')]"]]
 DocTest.printPrefix "Data.List.HT.Private:1246: "
{-# LINE 1246 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1246 "src/Data/List/HT/Private.hs" #-}
      \x xs -> mapAdjacent subtract (scanl (+) x xs) === (xs::[Integer])
  )
 DocTest.printPrefix "Data.List.HT.Private:1254: "
{-# LINE 1254 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1254 "src/Data/List/HT/Private.hs" #-}
      \xs -> mapAdjacent (,) xs === mapAdjacentPointfree (,) (xs::String)
  )
 DocTest.printPrefix "Data.List.HT.Private:1261: "
{-# LINE 1261 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1261 "src/Data/List/HT/Private.hs" #-}
    let f x y z = [x,y]++show(z::Int) in mapAdjacent1 f 'a' [('b',1), ('c',2), ('d',3)]
  )
  [ExpectedLine [LineChunk "[\"ab1\",\"bc2\",\"cd3\"]"]]
 DocTest.printPrefix "Data.List.HT.Private:1270: "
{-# LINE 1270 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1270 "src/Data/List/HT/Private.hs" #-}
    equalWith (<=) "ab" "bb"
  )
  [ExpectedLine [LineChunk "True"]]
 DocTest.printPrefix "Data.List.HT.Private:1272: "
{-# LINE 1272 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1272 "src/Data/List/HT/Private.hs" #-}
    equalWith (<=) "aa" "bbb"
  )
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1274: "
{-# LINE 1274 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1274 "src/Data/List/HT/Private.hs" #-}
    equalWith (==) "aa" "aaa"
  )
  [ExpectedLine [LineChunk "False"]]
 DocTest.printPrefix "Data.List.HT.Private:1277: "
{-# LINE 1277 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1277 "src/Data/List/HT/Private.hs" #-}
      \as bs -> let f a b = abs (a-b) <= (10::Int) in equalWith f as bs ===  equalWithRec f as bs
  )
 DocTest.printPrefix "Data.List.HT.Private:1278: "
{-# LINE 1278 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1278 "src/Data/List/HT/Private.hs" #-}
      \as bs -> let f a b = abs (a-b) <= (10::Int) in equalWith f as bs ===  equalWithLiftM f as bs
  )
 DocTest.printPrefix "Data.List.HT.Private:1314: "
{-# LINE 1314 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1314 "src/Data/List/HT/Private.hs" #-}
    range 0 :: [Integer]
  )
  [ExpectedLine [LineChunk "[]"]]
 DocTest.printPrefix "Data.List.HT.Private:1316: "
{-# LINE 1316 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1316 "src/Data/List/HT/Private.hs" #-}
    range 1 :: [Integer]
  )
  [ExpectedLine [LineChunk "[0]"]]
 DocTest.printPrefix "Data.List.HT.Private:1318: "
{-# LINE 1318 "src/Data/List/HT/Private.hs" #-}
 DocTest.example(
{-# LINE 1318 "src/Data/List/HT/Private.hs" #-}
    range 8 :: [Integer]
  )
  [ExpectedLine [LineChunk "[0,1,2,3,4,5,6,7]"]]
 DocTest.printPrefix "Data.List.HT.Private:1321: "
{-# LINE 1321 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1321 "src/Data/List/HT/Private.hs" #-}
      \(NonNegative n) -> length (range n :: [Integer]) === n
  )
 DocTest.printPrefix "Data.List.HT.Private:1348: "
{-# LINE 1348 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1348 "src/Data/List/HT/Private.hs" #-}
      \x -> equating (take 1000) (List.iterate (x+) x) (iterateAssociative (+) (x::Integer))
  )
 DocTest.printPrefix "Data.List.HT.Private:1367: "
{-# LINE 1367 "src/Data/List/HT/Private.hs" #-}
 DocTest.property(
{-# LINE 1367 "src/Data/List/HT/Private.hs" #-}
      \x -> equating (take 1000) (List.iterate (x+) x) (iterateLeaky (+) (x::Integer))
  )
