module Stratosphere.QuickSight.Template.FilterOperationSelectedFieldsConfigurationProperty (
        module Exports,
        FilterOperationSelectedFieldsConfigurationProperty(..),
        mkFilterOperationSelectedFieldsConfigurationProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.QuickSight.Template.ColumnIdentifierProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data FilterOperationSelectedFieldsConfigurationProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-filteroperationselectedfieldsconfiguration.html>
    FilterOperationSelectedFieldsConfigurationProperty {haddock_workaround_ :: (),
                                                        -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-filteroperationselectedfieldsconfiguration.html#cfn-quicksight-template-filteroperationselectedfieldsconfiguration-selectedcolumns>
                                                        selectedColumns :: (Prelude.Maybe [ColumnIdentifierProperty]),
                                                        -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-filteroperationselectedfieldsconfiguration.html#cfn-quicksight-template-filteroperationselectedfieldsconfiguration-selectedfieldoptions>
                                                        selectedFieldOptions :: (Prelude.Maybe (Value Prelude.Text)),
                                                        -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-filteroperationselectedfieldsconfiguration.html#cfn-quicksight-template-filteroperationselectedfieldsconfiguration-selectedfields>
                                                        selectedFields :: (Prelude.Maybe (ValueList Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkFilterOperationSelectedFieldsConfigurationProperty ::
  FilterOperationSelectedFieldsConfigurationProperty
mkFilterOperationSelectedFieldsConfigurationProperty
  = FilterOperationSelectedFieldsConfigurationProperty
      {haddock_workaround_ = (), selectedColumns = Prelude.Nothing,
       selectedFieldOptions = Prelude.Nothing,
       selectedFields = Prelude.Nothing}
instance ToResourceProperties FilterOperationSelectedFieldsConfigurationProperty where
  toResourceProperties
    FilterOperationSelectedFieldsConfigurationProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::Template.FilterOperationSelectedFieldsConfiguration",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "SelectedColumns" Prelude.<$> selectedColumns,
                            (JSON..=) "SelectedFieldOptions" Prelude.<$> selectedFieldOptions,
                            (JSON..=) "SelectedFields" Prelude.<$> selectedFields])}
instance JSON.ToJSON FilterOperationSelectedFieldsConfigurationProperty where
  toJSON FilterOperationSelectedFieldsConfigurationProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "SelectedColumns" Prelude.<$> selectedColumns,
               (JSON..=) "SelectedFieldOptions" Prelude.<$> selectedFieldOptions,
               (JSON..=) "SelectedFields" Prelude.<$> selectedFields]))
instance Property "SelectedColumns" FilterOperationSelectedFieldsConfigurationProperty where
  type PropertyType "SelectedColumns" FilterOperationSelectedFieldsConfigurationProperty = [ColumnIdentifierProperty]
  set
    newValue
    FilterOperationSelectedFieldsConfigurationProperty {..}
    = FilterOperationSelectedFieldsConfigurationProperty
        {selectedColumns = Prelude.pure newValue, ..}
instance Property "SelectedFieldOptions" FilterOperationSelectedFieldsConfigurationProperty where
  type PropertyType "SelectedFieldOptions" FilterOperationSelectedFieldsConfigurationProperty = Value Prelude.Text
  set
    newValue
    FilterOperationSelectedFieldsConfigurationProperty {..}
    = FilterOperationSelectedFieldsConfigurationProperty
        {selectedFieldOptions = Prelude.pure newValue, ..}
instance Property "SelectedFields" FilterOperationSelectedFieldsConfigurationProperty where
  type PropertyType "SelectedFields" FilterOperationSelectedFieldsConfigurationProperty = ValueList Prelude.Text
  set
    newValue
    FilterOperationSelectedFieldsConfigurationProperty {..}
    = FilterOperationSelectedFieldsConfigurationProperty
        {selectedFields = Prelude.pure newValue, ..}