module Stratosphere.QuickSight.DataSet.ProjectOperationProperty (
        ProjectOperationProperty(..), mkProjectOperationProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data ProjectOperationProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html>
    ProjectOperationProperty {haddock_workaround_ :: (),
                              -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html#cfn-quicksight-dataset-projectoperation-projectedcolumns>
                              projectedColumns :: (Prelude.Maybe (ValueList Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkProjectOperationProperty :: ProjectOperationProperty
mkProjectOperationProperty
  = ProjectOperationProperty
      {haddock_workaround_ = (), projectedColumns = Prelude.Nothing}
instance ToResourceProperties ProjectOperationProperty where
  toResourceProperties ProjectOperationProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::DataSet.ProjectOperation",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "ProjectedColumns" Prelude.<$> projectedColumns])}
instance JSON.ToJSON ProjectOperationProperty where
  toJSON ProjectOperationProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "ProjectedColumns" Prelude.<$> projectedColumns]))
instance Property "ProjectedColumns" ProjectOperationProperty where
  type PropertyType "ProjectedColumns" ProjectOperationProperty = ValueList Prelude.Text
  set newValue ProjectOperationProperty {..}
    = ProjectOperationProperty
        {projectedColumns = Prelude.pure newValue, ..}