module Stratosphere.QuickSight.Dashboard.PieChartAggregatedFieldWellsProperty (
        module Exports, PieChartAggregatedFieldWellsProperty(..),
        mkPieChartAggregatedFieldWellsProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.QuickSight.Dashboard.DimensionFieldProperty as Exports
import {-# SOURCE #-} Stratosphere.QuickSight.Dashboard.MeasureFieldProperty as Exports
import Stratosphere.ResourceProperties
data PieChartAggregatedFieldWellsProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-piechartaggregatedfieldwells.html>
    PieChartAggregatedFieldWellsProperty {haddock_workaround_ :: (),
                                          -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-piechartaggregatedfieldwells.html#cfn-quicksight-dashboard-piechartaggregatedfieldwells-category>
                                          category :: (Prelude.Maybe [DimensionFieldProperty]),
                                          -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-piechartaggregatedfieldwells.html#cfn-quicksight-dashboard-piechartaggregatedfieldwells-smallmultiples>
                                          smallMultiples :: (Prelude.Maybe [DimensionFieldProperty]),
                                          -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-piechartaggregatedfieldwells.html#cfn-quicksight-dashboard-piechartaggregatedfieldwells-values>
                                          values :: (Prelude.Maybe [MeasureFieldProperty])}
  deriving stock (Prelude.Eq, Prelude.Show)
mkPieChartAggregatedFieldWellsProperty ::
  PieChartAggregatedFieldWellsProperty
mkPieChartAggregatedFieldWellsProperty
  = PieChartAggregatedFieldWellsProperty
      {haddock_workaround_ = (), category = Prelude.Nothing,
       smallMultiples = Prelude.Nothing, values = Prelude.Nothing}
instance ToResourceProperties PieChartAggregatedFieldWellsProperty where
  toResourceProperties PieChartAggregatedFieldWellsProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::Dashboard.PieChartAggregatedFieldWells",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "Category" Prelude.<$> category,
                            (JSON..=) "SmallMultiples" Prelude.<$> smallMultiples,
                            (JSON..=) "Values" Prelude.<$> values])}
instance JSON.ToJSON PieChartAggregatedFieldWellsProperty where
  toJSON PieChartAggregatedFieldWellsProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "Category" Prelude.<$> category,
               (JSON..=) "SmallMultiples" Prelude.<$> smallMultiples,
               (JSON..=) "Values" Prelude.<$> values]))
instance Property "Category" PieChartAggregatedFieldWellsProperty where
  type PropertyType "Category" PieChartAggregatedFieldWellsProperty = [DimensionFieldProperty]
  set newValue PieChartAggregatedFieldWellsProperty {..}
    = PieChartAggregatedFieldWellsProperty
        {category = Prelude.pure newValue, ..}
instance Property "SmallMultiples" PieChartAggregatedFieldWellsProperty where
  type PropertyType "SmallMultiples" PieChartAggregatedFieldWellsProperty = [DimensionFieldProperty]
  set newValue PieChartAggregatedFieldWellsProperty {..}
    = PieChartAggregatedFieldWellsProperty
        {smallMultiples = Prelude.pure newValue, ..}
instance Property "Values" PieChartAggregatedFieldWellsProperty where
  type PropertyType "Values" PieChartAggregatedFieldWellsProperty = [MeasureFieldProperty]
  set newValue PieChartAggregatedFieldWellsProperty {..}
    = PieChartAggregatedFieldWellsProperty
        {values = Prelude.pure newValue, ..}