{-# LANGUAGE FlexibleContexts, TemplateHaskell, UndecidableInstances, BangPatterns, PackageImports, TypeFamilies, RankNTypes #-}
module Text.Papillon.Parser (
	Lookahead(..),
	Lists(..),

	Peg,
	Definition,
	Selection,
	Expression,
	Check,
	ReadFrom(..),

	hsw,

	pprCheck,

	parse,
	Source(..),
	SourceList(..),
	Derivs(pegFile, peg, char),
	ParseError(..),
	mkParseError,
	pePositionS,
	Pos(..),
	ListPos(..),

	PPragma(..),
	ModuleName,
	Exports,
	Code,

	runError,

	dvCharsN

) where

import Text.Papillon.Papillon
import "monads-tf" Control.Monad.State
import "monads-tf" Control.Monad.Error
import Control.Applicative(Applicative, (<$>), (<*>))

import Language.Haskell.TH {- (
	Name, TypeQ, PatQ, ExpQ, mkName,
	conT, tupleT, listT, appT, arrowT,
	wildP, litP, varP, conP, tupP, listP, uInfixP,
	litE, varE, conE, tupE, listE, sigE, appE, infixE, uInfixE, lamE,
	integerL, charL, stringL) -}
import Data.Char (isDigit, isUpper, isLower, isAlphaNum, isHexDigit, chr)
import Numeric (readHex)

import Language.Haskell.TH.PprLib
	((<>), hsep, colon, brackets, text, braces, Doc, parens, (<+>), quotes)
import qualified Language.Haskell.TH.PprLib as P
import Control.Arrow ((***))
import Data.List
import Data.Maybe

data Lookahead = Here | Ahead | NAhead String deriving (Show, Eq)
data Lists = List | List1 | Optional deriving (Show, Eq)

type PegFile = ([PPragma], ModuleName, Maybe Exports, Code, STPeg, Code)
data PPragma = LanguagePragma [String] | OtherPragma String deriving Show
type ModuleName = [String]
type Exports = String
type Code = String

type STPeg = (Maybe Type, Type, Peg)
type Peg = [Definition]
type Definition = (String, Maybe Type, Selection)
type Selection = [Expression]
type Expression = Either ([(Lookahead, Check)], Maybe Exp) Exp
type Check = Either ((Pat, String), ReadFrom, Maybe (Exp, String)) (Char, Lists)
data ReadFrom
	= FromVariable (Maybe String)
	| FromSelection Selection
	| FromL Lists ReadFrom
	deriving Show

pprCheck :: Check -> Doc
pprCheck (Left ((pt, _), rf, tst)) =
	ppr pt <> colon <> ppr rf <> maybe P.empty (brackets . ppr . fst) tst
pprCheck (Right (c, l)) = quotes (P.char c) <> ppr l

instance Ppr ReadFrom where
	ppr (FromVariable (Just v)) = text v
	ppr (FromVariable _) = P.empty
	ppr (FromL l rf) = ppr rf <> ppr l
	ppr (FromSelection sel) = parens $ ps sel
		where
		ps = hsep . intersperse (P.char '/') . map pe
		pe (Left (ex, hs)) = (<+> braces (maybe P.empty ppr hs)) $ hsep $
			map (uncurry ($) . (((<>) . ppr) *** pprCheck)) ex
		pe (Right ex) = P.char '<' <> ppr ex <> P.char '>'


instance Ppr Lookahead where
	ppr Here = P.empty
	ppr Ahead = P.char '&'
	ppr (NAhead _) = P.char '!'

instance Ppr Lists where
	ppr List = P.char '*'
	ppr List1 = P.char '+'
	ppr Optional = P.char '?'

mkPegFile :: [PPragma] -> Maybe ([String], Maybe String) -> String -> String ->
	STPeg -> String -> PegFile
mkPegFile ps (Just md) x y z w = (ps, fst md, snd md, x ++ "\n" ++ y, z, w)
mkPegFile ps Nothing x y z w = (ps, [], Nothing, x ++ "\n" ++ y, z, w)

dvCharsN :: String
dvCharsN = "char"

opChars :: String
opChars = ":!#$%&*+./<=>?@\\^|-~"

data Word
	= WSymbol String
	| WType [String] String
	| WVar [String] String
	| WOpCon String
	| WOp String
	| WChar Char
	| WString String
	| WInteger Integer
	| WOQuasiQuote String
	| WCQuasiQuote

	-- ["module", "where", "import"]
	| WModule
	| WWhere
	| WImport

	-- ["::", "->", "..", "{-#", "#-}"]
	| WTypeDef
	| WRightArrow
	| WDotDot
	| WOComment
	| WCComment

	-- "!&*+?=/:<>"
	| WBang
	| WAmp
	| WAsterisk
	| WPlus
	| WQuestion
	| WEqual
	| WSlash
	| WColon
	| WLT
	| WGT

	-- "[]{}()"
	| WOBracket
	| WCBracket
	| WOBrace
	| WCBrace
	| WOParen
	| WCParen

	-- ",;`"
	| WComma
	| WSemiColon
	| WBackQuote
	deriving Show


data Derivs
    = Derivs {pegFile :: (ErrorT (ParseError (Pos String) Derivs)
                                 (State ((Maybe Int)))
                                 ((PegFile, Derivs))),
              pragma :: (ErrorT (ParseError (Pos String) Derivs)
                                (State ((Maybe Int)))
                                ((PPragma, Derivs))),
              pragmaStr :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   ((String, Derivs))),
              pragmaItems :: (ErrorT (ParseError (Pos String) Derivs)
                                     (State ((Maybe Int)))
                                     (([String], Derivs))),
              moduleDec :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   ((Maybe (([String], Maybe String)), Derivs))),
              moduleName :: (ErrorT (ParseError (Pos String) Derivs)
                                    (State ((Maybe Int)))
                                    ((ModuleName, Derivs))),
              moduleDecStr :: (ErrorT (ParseError (Pos String) Derivs)
                                      (State ((Maybe Int)))
                                      ((String, Derivs))),
              whr :: (ErrorT (ParseError (Pos String) Derivs)
                             (State ((Maybe Int)))
                             (((), Derivs))),
              preImpPap :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   ((String, Derivs))),
              prePeg :: (ErrorT (ParseError (Pos String) Derivs)
                                (State ((Maybe Int)))
                                ((String, Derivs))),
              afterPeg :: (ErrorT (ParseError (Pos String) Derivs)
                                  (State ((Maybe Int)))
                                  ((String, Derivs))),
              importPapillon :: (ErrorT (ParseError (Pos String) Derivs)
                                        (State ((Maybe Int)))
                                        (((), Derivs))),
              peg :: (ErrorT (ParseError (Pos String) Derivs)
                             (State ((Maybe Int)))
                             ((STPeg, Derivs))),
              peg_ :: (ErrorT (ParseError (Pos String) Derivs)
                              (State ((Maybe Int)))
                              ((STPeg, Derivs))),
              monadType :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   ((Type, Derivs))),
              sourceType :: (ErrorT (ParseError (Pos String) Derivs)
                                    (State ((Maybe Int)))
                                    ((Type, Derivs))),
              definition :: (ErrorT (ParseError (Pos String) Derivs)
                                    (State ((Maybe Int)))
                                    ((Definition, Derivs))),
              selection :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   (([Expression], Derivs))),
              normalSelection :: (ErrorT (ParseError (Pos String) Derivs)
                                         (State ((Maybe Int)))
                                         (([Expression], Derivs))),
              expressionHs :: (ErrorT (ParseError (Pos String) Derivs)
                                      (State ((Maybe Int)))
                                      ((Expression, Derivs))),
              expressionHsSugar :: (ErrorT (ParseError (Pos String) Derivs)
                                           (State ((Maybe Int)))
                                           ((Expression, Derivs))),
              expressionHsSugar' :: (ErrorT (ParseError (Pos String) Derivs)
                                            (State ((Maybe Int)))
                                            ((Expression, Derivs))),
              expression :: (ErrorT (ParseError (Pos String) Derivs)
                                    (State ((Maybe Int)))
                                    (([(Lookahead, Check)], Derivs))),
              nameLeaf_ :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   (((Lookahead, Check), Derivs))),
              nameLeaf :: (ErrorT (ParseError (Pos String) Derivs)
                                  (State ((Maybe Int)))
                                  ((Check, Derivs))),
              nameLeafNoCom :: (ErrorT (ParseError (Pos String) Derivs)
                                       (State ((Maybe Int)))
                                       ((Check, Derivs))),
              comForErr :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   ((String, Derivs))),
              leaf :: (ErrorT (ParseError (Pos String) Derivs)
                              (State ((Maybe Int)))
                              (((ReadFrom, Maybe ((Exp, String))), Derivs))),
              patOp :: (ErrorT (ParseError (Pos String) Derivs)
                               (State ((Maybe Int)))
                               ((Pat, Derivs))),
              pat :: (ErrorT (ParseError (Pos String) Derivs)
                             (State ((Maybe Int)))
                             ((Pat, Derivs))),
              pat1 :: (ErrorT (ParseError (Pos String) Derivs)
                              (State ((Maybe Int)))
                              ((Pat, Derivs))),
              patList :: (ErrorT (ParseError (Pos String) Derivs)
                                 (State ((Maybe Int)))
                                 (([Pat], Derivs))),
              pats :: (ErrorT (ParseError (Pos String) Derivs)
                              (State ((Maybe Int)))
                              (([Pat], Derivs))),
              charLitLs :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   ((Check, Derivs))),
              readFromLs :: (ErrorT (ParseError (Pos String) Derivs)
                                    (State ((Maybe Int)))
                                    ((ReadFrom, Derivs))),
              readFrom :: (ErrorT (ParseError (Pos String) Derivs)
                                  (State ((Maybe Int)))
                                  ((ReadFrom, Derivs))),
              test :: (ErrorT (ParseError (Pos String) Derivs)
                              (State ((Maybe Int)))
                              (((Exp, String), Derivs))),
              hsExpLam :: (ErrorT (ParseError (Pos String) Derivs)
                                  (State ((Maybe Int)))
                                  ((Exp, Derivs))),
              hsExpTyp :: (ErrorT (ParseError (Pos String) Derivs)
                                  (State ((Maybe Int)))
                                  ((Exp, Derivs))),
              hsExpOp :: (ErrorT (ParseError (Pos String) Derivs)
                                 (State ((Maybe Int)))
                                 ((Exp, Derivs))),
              hsOp :: (ErrorT (ParseError (Pos String) Derivs)
                              (State ((Maybe Int)))
                              ((Exp, Derivs))),
              hsExpLam' :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   ((Exp, Derivs))),
              hsExpTyp' :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   ((Exp, Derivs))),
              hsExpOp' :: (ErrorT (ParseError (Pos String) Derivs)
                                  (State ((Maybe Int)))
                                  ((Exp, Derivs))),
              hsOp' :: (ErrorT (ParseError (Pos String) Derivs)
                               (State ((Maybe Int)))
                               ((Exp, Derivs))),
              hsExp :: (ErrorT (ParseError (Pos String) Derivs)
                               (State ((Maybe Int)))
                               (((Exp -> Exp) -> Exp, Derivs))),
              hsExp1 :: (ErrorT (ParseError (Pos String) Derivs)
                                (State ((Maybe Int)))
                                ((Exp, Derivs))),
              hsExpTpl :: (ErrorT (ParseError (Pos String) Derivs)
                                  (State ((Maybe Int)))
                                  (([Exp], Derivs))),
              hsTypeArr :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   ((Type, Derivs))),
              hsType :: (ErrorT (ParseError (Pos String) Derivs)
                                (State ((Maybe Int)))
                                (((Type -> Type) -> Type, Derivs))),
              hsType1 :: (ErrorT (ParseError (Pos String) Derivs)
                                 (State ((Maybe Int)))
                                 ((Type, Derivs))),
              hsTypeTpl :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   (([Type], Derivs))),
              wrd :: (ErrorT (ParseError (Pos String) Derivs)
                             (State ((Maybe Int)))
                             ((Word, Derivs))),
              hsw :: (ErrorT (ParseError (Pos String) Derivs)
                             (State ((Maybe Int)))
                             ((Word, Derivs))),
              word :: (ErrorT (ParseError (Pos String) Derivs)
                              (State ((Maybe Int)))
                              ((Word, Derivs))),
              hsWord :: (ErrorT (ParseError (Pos String) Derivs)
                                (State ((Maybe Int)))
                                ((Word, Derivs))),
              bras :: (ErrorT (ParseError (Pos String) Derivs)
                              (State ((Maybe Int)))
                              ((Word, Derivs))),
              typ :: (ErrorT (ParseError (Pos String) Derivs)
                             (State ((Maybe Int)))
                             ((String, Derivs))),
              var :: (ErrorT (ParseError (Pos String) Derivs)
                             (State ((Maybe Int)))
                             ((String, Derivs))),
              strLit :: (ErrorT (ParseError (Pos String) Derivs)
                                (State ((Maybe Int)))
                                ((String, Derivs))),
              escChar :: (ErrorT (ParseError (Pos String) Derivs)
                                 (State ((Maybe Int)))
                                 ((Char, Derivs))),
              space :: (ErrorT (ParseError (Pos String) Derivs)
                               (State ((Maybe Int)))
                               (((), Derivs))),
              space' :: (ErrorT (ParseError (Pos String) Derivs)
                                (State ((Maybe Int)))
                                (((), Derivs))),
              lineComment :: (ErrorT (ParseError (Pos String) Derivs)
                                     (State ((Maybe Int)))
                                     (((), Derivs))),
              comment :: (ErrorT (ParseError (Pos String) Derivs)
                                 (State ((Maybe Int)))
                                 (((), Derivs))),
              comments :: (ErrorT (ParseError (Pos String) Derivs)
                                  (State ((Maybe Int)))
                                  (((), Derivs))),
              comStr :: (ErrorT (ParseError (Pos String) Derivs)
                                (State ((Maybe Int)))
                                (((), Derivs))),
              semiColon :: (ErrorT (ParseError (Pos String) Derivs)
                                   (State ((Maybe Int)))
                                   (((), Derivs))),
              notSemiColon :: (ErrorT (ParseError (Pos String) Derivs)
                                      (State ((Maybe Int)))
                                      (((), Derivs))),
              char :: (ErrorT (ParseError (Pos String) Derivs)
                              (State ((Maybe Int)))
                              ((Token String, Derivs))),
              position :: (ErrorT (ParseError (Pos String) Derivs)
                                  (State ((Maybe Int)))
                                  ((Pos String, Derivs)))}
parse :: String -> Derivs
parse = parse1522_0 initialPos
          where parse1522_0 pos1521_1 s1523_2 = d142_3
                                where d142_3 = Derivs pegFile1_4 pragma2_5 pragmaStr3_6 pragmaItems4_7 moduleDec5_8 moduleName6_9 moduleDecStr7_10 whr8_11 preImpPap9_12 prePeg10_13 afterPeg11_14 importPapillon12_15 peg13_16 peg_14_17 monadType15_18 sourceType16_19 definition17_20 selection18_21 normalSelection19_22 expressionHs20_23 expressionHsSugar21_24 expressionHsSugar'22_25 expression23_26 nameLeaf_24_27 nameLeaf25_28 nameLeafNoCom26_29 comForErr27_30 leaf28_31 patOp29_32 pat30_33 pat131_34 patList32_35 pats33_36 charLitLs34_37 readFromLs35_38 readFrom36_39 test37_40 hsExpLam38_41 hsExpTyp39_42 hsExpOp40_43 hsOp41_44 hsExpLam'42_45 hsExpTyp'43_46 hsExpOp'44_47 hsOp'45_48 hsExp46_49 hsExp147_50 hsExpTpl48_51 hsTypeArr49_52 hsType50_53 hsType151_54 hsTypeTpl52_55 wrd53_56 hsw54_57 word55_58 hsWord56_59 bras57_60 typ58_61 var59_62 strLit60_63 escChar61_64 space62_65 space'63_66 lineComment64_67 comment65_68 comments66_69 comStr67_70 semiColon68_71 notSemiColon69_72 chars1524_73 (return (pos1521_1,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            d142_3))
                                      pegFile1_4 = runStateT pegFile70_74 d142_3
                                      pragma2_5 = runStateT pragma71_75 d142_3
                                      pragmaStr3_6 = runStateT pragmaStr72_76 d142_3
                                      pragmaItems4_7 = runStateT pragmaItems73_77 d142_3
                                      moduleDec5_8 = runStateT moduleDec74_78 d142_3
                                      moduleName6_9 = runStateT moduleName75_79 d142_3
                                      moduleDecStr7_10 = runStateT moduleDecStr76_80 d142_3
                                      whr8_11 = runStateT whr77_81 d142_3
                                      preImpPap9_12 = runStateT preImpPap78_82 d142_3
                                      prePeg10_13 = runStateT prePeg79_83 d142_3
                                      afterPeg11_14 = runStateT afterPeg80_84 d142_3
                                      importPapillon12_15 = runStateT importPapillon81_85 d142_3
                                      peg13_16 = runStateT peg82_86 d142_3
                                      peg_14_17 = runStateT peg_83_87 d142_3
                                      monadType15_18 = runStateT monadType84_88 d142_3
                                      sourceType16_19 = runStateT sourceType85_89 d142_3
                                      definition17_20 = runStateT definition86_90 d142_3
                                      selection18_21 = runStateT selection87_91 d142_3
                                      normalSelection19_22 = runStateT normalSelection88_92 d142_3
                                      expressionHs20_23 = runStateT expressionHs89_93 d142_3
                                      expressionHsSugar21_24 = runStateT expressionHsSugar90_94 d142_3
                                      expressionHsSugar'22_25 = runStateT expressionHsSugar'91_95 d142_3
                                      expression23_26 = runStateT expression92_96 d142_3
                                      nameLeaf_24_27 = runStateT nameLeaf_93_97 d142_3
                                      nameLeaf25_28 = runStateT nameLeaf94_98 d142_3
                                      nameLeafNoCom26_29 = runStateT nameLeafNoCom95_99 d142_3
                                      comForErr27_30 = runStateT comForErr96_100 d142_3
                                      leaf28_31 = runStateT leaf97_101 d142_3
                                      patOp29_32 = runStateT patOp98_102 d142_3
                                      pat30_33 = runStateT pat99_103 d142_3
                                      pat131_34 = runStateT pat1100_104 d142_3
                                      patList32_35 = runStateT patList101_105 d142_3
                                      pats33_36 = runStateT pats102_106 d142_3
                                      charLitLs34_37 = runStateT charLitLs103_107 d142_3
                                      readFromLs35_38 = runStateT readFromLs104_108 d142_3
                                      readFrom36_39 = runStateT readFrom105_109 d142_3
                                      test37_40 = runStateT test106_110 d142_3
                                      hsExpLam38_41 = runStateT hsExpLam107_111 d142_3
                                      hsExpTyp39_42 = runStateT hsExpTyp108_112 d142_3
                                      hsExpOp40_43 = runStateT hsExpOp109_113 d142_3
                                      hsOp41_44 = runStateT hsOp110_114 d142_3
                                      hsExpLam'42_45 = runStateT hsExpLam'111_115 d142_3
                                      hsExpTyp'43_46 = runStateT hsExpTyp'112_116 d142_3
                                      hsExpOp'44_47 = runStateT hsExpOp'113_117 d142_3
                                      hsOp'45_48 = runStateT hsOp'114_118 d142_3
                                      hsExp46_49 = runStateT hsExp115_119 d142_3
                                      hsExp147_50 = runStateT hsExp1116_120 d142_3
                                      hsExpTpl48_51 = runStateT hsExpTpl117_121 d142_3
                                      hsTypeArr49_52 = runStateT hsTypeArr118_122 d142_3
                                      hsType50_53 = runStateT hsType119_123 d142_3
                                      hsType151_54 = runStateT hsType1120_124 d142_3
                                      hsTypeTpl52_55 = runStateT hsTypeTpl121_125 d142_3
                                      wrd53_56 = runStateT wrd122_126 d142_3
                                      hsw54_57 = runStateT hsw123_127 d142_3
                                      word55_58 = runStateT word124_128 d142_3
                                      hsWord56_59 = runStateT hsWord125_129 d142_3
                                      bras57_60 = runStateT bras126_130 d142_3
                                      typ58_61 = runStateT typ127_131 d142_3
                                      var59_62 = runStateT var128_132 d142_3
                                      strLit60_63 = runStateT strLit129_133 d142_3
                                      escChar61_64 = runStateT escChar130_134 d142_3
                                      space62_65 = runStateT space131_135 d142_3
                                      space'63_66 = runStateT space'132_136 d142_3
                                      lineComment64_67 = runStateT lineComment133_137 d142_3
                                      comment65_68 = runStateT comment134_138 d142_3
                                      comments66_69 = runStateT comments135_139 d142_3
                                      comStr67_70 = runStateT comStr136_140 d142_3
                                      semiColon68_71 = runStateT semiColon137_141 d142_3
                                      notSemiColon69_72 = runStateT notSemiColon138_142 d142_3
                                      chars1524_73 = runStateT (case getToken s1523_2 of
                                                                    Just (c1506_143,
                                                                          s'1520_144) -> do put (parse1522_0 (updatePos c1506_143 pos1521_1) s'1520_144)
                                                                                            return c1506_143
                                                                    _ -> StateT position >>= (throwError . mkParseError "" "end of input" "" undefined [])) d142_3
                pegFile70_74 = foldl1 mplus [do pr <- list140_145 (StateT pragma)
                                                md <- StateT moduleDec
                                                pip <- StateT preImpPap
                                                _ <- StateT importPapillon
                                                return ()
                                                pp <- StateT prePeg
                                                d147_146 <- get
                                                t610_147 <- StateT hsw
                                                case t610_147 of
                                                    (WOQuasiQuote "papillon") -> return ()
                                                    _ -> StateT position >>= (throwError . mkParseError "(WOQuasiQuote \"papillon\")" "not match pattern: " "" d147_146 ["hsw"])
                                                let (WOQuasiQuote "papillon") = t610_147
                                                return ()
                                                p <- StateT peg_
                                                d149_148 <- get
                                                t612_149 <- StateT hsw
                                                case t612_149 of
                                                    WCQuasiQuote -> return ()
                                                    _ -> StateT position >>= (throwError . mkParseError "WCQuasiQuote" "not match pattern: " "" d149_148 ["hsw"])
                                                let WCQuasiQuote = t612_149
                                                return ()
                                                atp <- StateT afterPeg
                                                lift (lift (return $ mkPegFile pr md pip pp p atp)),
                                             do pr <- list140_145 (StateT pragma)
                                                md <- StateT moduleDec
                                                pp <- StateT prePeg
                                                d154_150 <- get
                                                t617_151 <- StateT hsw
                                                case t617_151 of
                                                    (WOQuasiQuote "papillon") -> return ()
                                                    _ -> StateT position >>= (throwError . mkParseError "(WOQuasiQuote \"papillon\")" "not match pattern: " "" d154_150 ["hsw"])
                                                let (WOQuasiQuote "papillon") = t617_151
                                                return ()
                                                p <- StateT peg_
                                                d156_152 <- get
                                                t619_153 <- StateT hsw
                                                case t619_153 of
                                                    WCQuasiQuote -> return ()
                                                    _ -> StateT position >>= (throwError . mkParseError "WCQuasiQuote" "not match pattern: " "" d156_152 ["hsw"])
                                                let WCQuasiQuote = t619_153
                                                return ()
                                                atp <- StateT afterPeg
                                                lift (lift (return $ mkPegFile pr md [] pp p atp))]
                pragma71_75 = foldl1 mplus [do d158_154 <- get
                                               t621_155 <- StateT hsw
                                               case t621_155 of
                                                   WOComment -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WOComment" "not match pattern: " "" d158_154 ["hsw"])
                                               let WOComment = t621_155
                                               return ()
                                               d159_156 <- get
                                               t622_157 <- StateT hsw
                                               case t622_157 of
                                                   (WType [] "LANGUAGE") -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WType [] \"LANGUAGE\")" "not match pattern: " "" d159_156 ["hsw"])
                                               let (WType [] "LANGUAGE") = t622_157
                                               return ()
                                               s <- StateT pragmaItems
                                               d161_158 <- get
                                               t624_159 <- StateT hsw
                                               case t624_159 of
                                                   WCComment -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WCComment" "not match pattern: " "" d161_158 ["hsw"])
                                               let WCComment = t624_159
                                               return ()
                                               lift (lift (return $ LanguagePragma s)),
                                            do d162_160 <- get
                                               t625_161 <- StateT hsw
                                               case t625_161 of
                                                   WOComment -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WOComment" "not match pattern: " "" d162_160 ["hsw"])
                                               let WOComment = t625_161
                                               return ()
                                               s <- StateT pragmaStr
                                               d164_162 <- get
                                               t627_163 <- StateT hsw
                                               case t627_163 of
                                                   WCComment -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WCComment" "not match pattern: " "" d164_162 ["hsw"])
                                               let WCComment = t627_163
                                               return ()
                                               lift (lift (return $ OtherPragma s))]
                pragmaStr72_76 = foldl1 mplus [do d166_164 <- get
                                                  do err1494_165 <- ((do d165_166 <- get
                                                                         t628_167 <- StateT hsw
                                                                         case t628_167 of
                                                                             WCComment -> return ()
                                                                             _ -> StateT position >>= (throwError . mkParseError "WCComment" "not match pattern: " "" d165_166 ["hsw"])
                                                                         let WCComment = t628_167
                                                                         return ()) >> return False) `catchError` const (return True)
                                                     unless err1494_165 (StateT position >>= (throwError . mkParseError "!WCComment:hsw" "not match: " "" d166_164 ["hsw"]))
                                                  put d166_164
                                                  c <- StateT char
                                                  s <- StateT pragmaStr
                                                  lift (lift (return $ c : s)),
                                               lift (lift (return ""))]
                pragmaItems73_77 = foldl1 mplus [do d169_168 <- get
                                                    t631_169 <- StateT hsw
                                                    case t631_169 of
                                                        (WType [] _) -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "(WType [] t)" "not match pattern: " "" d169_168 ["hsw"])
                                                    let (WType [] t) = t631_169
                                                    return ()
                                                    d170_170 <- get
                                                    t632_171 <- StateT hsw
                                                    case t632_171 of
                                                        WComma -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "WComma" "not match pattern: " "" d170_170 ["hsw"])
                                                    let WComma = t632_171
                                                    return ()
                                                    i <- StateT pragmaItems
                                                    lift (lift (return $ t : i)),
                                                 do d172_172 <- get
                                                    t634_173 <- StateT hsw
                                                    case t634_173 of
                                                        (WType [] _) -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "(WType [] t)" "not match pattern: " "" d172_172 ["hsw"])
                                                    let (WType [] t) = t634_173
                                                    return ()
                                                    lift (lift (return [t]))]
                moduleDec74_78 = foldl1 mplus [do d173_174 <- get
                                                  t635_175 <- StateT hsw
                                                  case t635_175 of
                                                      WModule -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WModule" "not match pattern: " "" d173_174 ["hsw"])
                                                  let WModule = t635_175
                                                  return ()
                                                  n <- StateT moduleName
                                                  d175_176 <- get
                                                  t637_177 <- StateT hsw
                                                  case t637_177 of
                                                      WOParen -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WOParen" "not match pattern: " "" d175_176 ["hsw"])
                                                  let WOParen = t637_177
                                                  return ()
                                                  s <- StateT moduleDecStr
                                                  _ <- StateT whr
                                                  return ()
                                                  lift (lift (return $ Just (n, Just s))),
                                               do d178_178 <- get
                                                  t640_179 <- StateT hsw
                                                  case t640_179 of
                                                      WModule -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WModule" "not match pattern: " "" d178_178 ["hsw"])
                                                  let WModule = t640_179
                                                  return ()
                                                  n <- StateT moduleName
                                                  d180_180 <- get
                                                  t642_181 <- StateT hsw
                                                  case t642_181 of
                                                      WWhere -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WWhere" "not match pattern: " "" d180_180 ["hsw"])
                                                  let WWhere = t642_181
                                                  return ()
                                                  lift (lift (return $ Just (n, Nothing))),
                                               lift (lift (return Nothing))]
                moduleName75_79 = foldl1 mplus [do d181_182 <- get
                                                   t643_183 <- StateT hsw
                                                   case t643_183 of
                                                       (WType _ _) -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "(WType m t)" "not match pattern: " "" d181_182 ["hsw"])
                                                   let (WType m t) = t643_183
                                                   return ()
                                                   lift (lift (return $ m ++ [t]))]
                moduleDecStr76_80 = foldl1 mplus [do d183_184 <- get
                                                     do err1495_185 <- ((do _ <- StateT whr
                                                                            return ()) >> return False) `catchError` const (return True)
                                                        unless err1495_185 (StateT position >>= (throwError . mkParseError "!_:whr" "not match: " "" d183_184 ["whr"]))
                                                     put d183_184
                                                     c <- StateT char
                                                     s <- StateT moduleDecStr
                                                     lift (lift (return $ c : s)),
                                                  lift (lift (return ""))]
                whr77_81 = foldl1 mplus [do d186_186 <- get
                                            t647_187 <- StateT hsw
                                            case t647_187 of
                                                WCParen -> return ()
                                                _ -> StateT position >>= (throwError . mkParseError "WCParen" "not match pattern: " "" d186_186 ["hsw"])
                                            let WCParen = t647_187
                                            return ()
                                            d187_188 <- get
                                            t648_189 <- StateT hsw
                                            case t648_189 of
                                                WWhere -> return ()
                                                _ -> StateT position >>= (throwError . mkParseError "WWhere" "not match pattern: " "" d187_188 ["hsw"])
                                            let WWhere = t648_189
                                            return ()
                                            return ()]
                preImpPap78_82 = foldl1 mplus [do d189_190 <- get
                                                  do err1496_191 <- ((do _ <- StateT importPapillon
                                                                         return ()) >> return False) `catchError` const (return True)
                                                     unless err1496_191 (StateT position >>= (throwError . mkParseError "!_:importPapillon" "not match: " "" d189_190 ["importPapillon"]))
                                                  put d189_190
                                                  d191_192 <- get
                                                  do err1497_193 <- ((do d190_194 <- get
                                                                         t650_195 <- StateT hsw
                                                                         case t650_195 of
                                                                             (WOQuasiQuote "papillon") -> return ()
                                                                             _ -> StateT position >>= (throwError . mkParseError "(WOQuasiQuote \"papillon\")" "not match pattern: " "" d190_194 ["hsw"])
                                                                         let (WOQuasiQuote "papillon") = t650_195
                                                                         return ()) >> return False) `catchError` const (return True)
                                                     unless err1497_193 (StateT position >>= (throwError . mkParseError "!(WOQuasiQuote \"papillon\"):hsw" "not match: " "" d191_192 ["hsw"]))
                                                  put d191_192
                                                  c <- StateT char
                                                  pip <- StateT preImpPap
                                                  lift (lift (return $ c : pip)),
                                               lift (lift (return ""))]
                prePeg79_83 = foldl1 mplus [do d195_196 <- get
                                               do err1498_197 <- ((do d194_198 <- get
                                                                      t653_199 <- StateT hsw
                                                                      case t653_199 of
                                                                          (WOQuasiQuote "papillon") -> return ()
                                                                          _ -> StateT position >>= (throwError . mkParseError "(WOQuasiQuote \"papillon\")" "not match pattern: " "" d194_198 ["hsw"])
                                                                      let (WOQuasiQuote "papillon") = t653_199
                                                                      return ()) >> return False) `catchError` const (return True)
                                                  unless err1498_197 (StateT position >>= (throwError . mkParseError "!(WOQuasiQuote \"papillon\"):hsw" "not match: " "" d195_196 ["hsw"]))
                                               put d195_196
                                               c <- StateT char
                                               pp <- StateT prePeg
                                               lift (lift (return $ c : pp)),
                                            lift (lift (return ""))]
                afterPeg80_84 = foldl1 mplus [do c <- StateT char
                                                 atp <- StateT afterPeg
                                                 lift (lift (return $ c : atp)),
                                              lift (lift (return ""))]
                importPapillon81_85 = foldl1 mplus [do d200_200 <- get
                                                       t658_201 <- StateT hsw
                                                       case t658_201 of
                                                           WImport -> return ()
                                                           _ -> StateT position >>= (throwError . mkParseError "WImport" "not match pattern: " "" d200_200 ["hsw"])
                                                       let WImport = t658_201
                                                       return ()
                                                       d201_202 <- get
                                                       t659_203 <- StateT hsw
                                                       case t659_203 of
                                                           (WType ["Text"] "Papillon") -> return ()
                                                           _ -> StateT position >>= (throwError . mkParseError "(WType [\"Text\"] \"Papillon\")" "not match pattern: " "" d201_202 ["hsw"])
                                                       let (WType ["Text"] "Papillon") = t659_203
                                                       return ()
                                                       return ()]
                peg82_86 = foldl1 mplus [do _ <- list140_145 (StateT space)
                                            return ()
                                            p <- StateT peg_
                                            lift (lift (return p))]
                peg_83_87 = foldl1 mplus [do mt <- optional139_204 (StateT monadType)
                                             st <- optional139_204 (StateT sourceType)
                                             p <- list140_145 (StateT definition)
                                             lift (lift (return (mt,
                                                                 fromMaybe (ConT $ mkName "String") st,
                                                                 p)))]
                monadType84_88 = foldl1 mplus [do d207_205 <- get
                                                  t665_206 <- StateT position
                                                  let (!(ListPos (CharPos (_, x)))) = t665_206
                                                  b1114_207 <- lift (lift (put (Just x) >> return True))
                                                  unless b1114_207 (StateT position >>= (throwError . mkParseError "put (Just x) >> return True" "not match: " "" d207_205 ["position"]))
                                                  d208_208 <- get
                                                  t666_209 <- StateT wrd
                                                  case t666_209 of
                                                      (WSymbol "monad") -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "(WSymbol \"monad\")" "not match pattern: " "" d208_208 ["wrd"])
                                                  let (WSymbol "monad") = t666_209
                                                  return ()
                                                  d209_210 <- get
                                                  t667_211 <- StateT wrd
                                                  case t667_211 of
                                                      WColon -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WColon" "not match pattern: " "" d209_210 ["wrd"])
                                                  let WColon = t667_211
                                                  return ()
                                                  t <- StateT hsTypeArr
                                                  d211_212 <- get
                                                  t669_213 <- StateT wrd
                                                  case t669_213 of
                                                      WSemiColon -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WSemiColon" "not match pattern: " "" d211_212 ["wrd"])
                                                  let WSemiColon = t669_213
                                                  return ()
                                                  lift (lift (put Nothing >> return t))]
                sourceType85_89 = foldl1 mplus [do d212_214 <- get
                                                   t670_215 <- StateT position
                                                   let (!(ListPos (CharPos (_, x)))) = t670_215
                                                   b1119_216 <- lift (lift (put (Just x) >> return True))
                                                   unless b1119_216 (StateT position >>= (throwError . mkParseError "put (Just x) >> return True" "not match: " "" d212_214 ["position"]))
                                                   d213_217 <- get
                                                   t671_218 <- StateT wrd
                                                   case t671_218 of
                                                       (WSymbol "source") -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "(WSymbol \"source\")" "not match pattern: " "" d213_217 ["wrd"])
                                                   let (WSymbol "source") = t671_218
                                                   return ()
                                                   d214_219 <- get
                                                   t672_220 <- StateT wrd
                                                   case t672_220 of
                                                       WColon -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WColon" "not match pattern: " "" d214_219 ["wrd"])
                                                   let WColon = t672_220
                                                   return ()
                                                   t <- StateT hsTypeArr
                                                   d216_221 <- get
                                                   t674_222 <- StateT wrd
                                                   case t674_222 of
                                                       WSemiColon -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WSemiColon" "not match pattern: " "" d216_221 ["wrd"])
                                                   let WSemiColon = t674_222
                                                   return ()
                                                   lift (lift (put Nothing >> return t))]
                definition86_90 = foldl1 mplus [do d217_223 <- get
                                                   t675_224 <- StateT position
                                                   let (!(ListPos (CharPos (_, x)))) = t675_224
                                                   b1124_225 <- lift (lift (put (Just x) >> return True))
                                                   unless b1124_225 (StateT position >>= (throwError . mkParseError "put (Just x) >> return True" "not match: " "" d217_223 ["position"]))
                                                   d218_226 <- get
                                                   t676_227 <- StateT wrd
                                                   case t676_227 of
                                                       (WSymbol _) -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "(WSymbol v)" "not match pattern: " "" d218_226 ["wrd"])
                                                   let (WSymbol v) = t676_227
                                                   return ()
                                                   mt <- optional139_204 (foldl1 mplus [do d220_228 <- get
                                                                                           t678_229 <- StateT hsw
                                                                                           case t678_229 of
                                                                                               WTypeDef -> return ()
                                                                                               _ -> StateT position >>= (throwError . mkParseError "WTypeDef" "not match pattern: " "" d220_228 ["hsw"])
                                                                                           let WTypeDef = t678_229
                                                                                           return ()
                                                                                           t <- StateT hsTypeArr
                                                                                           lift (lift (return t))])
                                                   d222_230 <- get
                                                   t680_231 <- StateT wrd
                                                   case t680_231 of
                                                       WEqual -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WEqual" "not match pattern: " "" d222_230 ["wrd"])
                                                   let WEqual = t680_231
                                                   return ()
                                                   sel <- StateT selection
                                                   d224_232 <- get
                                                   t682_233 <- StateT wrd
                                                   case t682_233 of
                                                       WSemiColon -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WSemiColon" "not match pattern: " "" d224_232 ["wrd"])
                                                   let WSemiColon = t682_233
                                                   return ()
                                                   lift (lift (put Nothing >> return (v, mt, sel)))]
                selection87_91 = foldl1 mplus [do ns <- StateT normalSelection
                                                  lift (lift (return ns))]
                normalSelection88_92 = foldl1 mplus [do ex <- StateT expressionHs
                                                        d227_234 <- get
                                                        t685_235 <- StateT wrd
                                                        case t685_235 of
                                                            WSlash -> return ()
                                                            _ -> StateT position >>= (throwError . mkParseError "WSlash" "not match pattern: " "" d227_234 ["wrd"])
                                                        let WSlash = t685_235
                                                        return ()
                                                        sel <- StateT normalSelection
                                                        lift (lift (return $ ex : sel)),
                                                     do ex <- StateT expressionHs
                                                        lift (lift (return [ex]))]
                expressionHs89_93 = foldl1 mplus [do e <- StateT expressionHsSugar
                                                     lift (lift (return e)),
                                                  do e <- StateT expression
                                                     mh <- optional139_204 (foldl1 mplus [do d233_236 <- get
                                                                                             t691_237 <- StateT wrd
                                                                                             case t691_237 of
                                                                                                 WOBrace -> return ()
                                                                                                 _ -> StateT position >>= (throwError . mkParseError "WOBrace" "not match pattern: " "" d233_236 ["wrd"])
                                                                                             let WOBrace = t691_237
                                                                                             return ()
                                                                                             h <- StateT hsExpLam
                                                                                             d235_238 <- get
                                                                                             t693_239 <- StateT wrd
                                                                                             case t693_239 of
                                                                                                 WCBrace -> return ()
                                                                                                 _ -> StateT position >>= (throwError . mkParseError "WCBrace" "not match pattern: " "" d235_238 ["wrd"])
                                                                                             let WCBrace = t693_239
                                                                                             return ()
                                                                                             lift (lift (return h))])
                                                     lift (lift (return $ Left (e, mh)))]
                expressionHsSugar90_94 = foldl1 mplus [do d236_240 <- get
                                                          t694_241 <- StateT wrd
                                                          case t694_241 of
                                                              WLT -> return ()
                                                              _ -> StateT position >>= (throwError . mkParseError "WLT" "not match pattern: " "" d236_240 ["wrd"])
                                                          let WLT = t694_241
                                                          return ()
                                                          h <- StateT hsExpLam
                                                          d238_242 <- get
                                                          t696_243 <- StateT wrd
                                                          case t696_243 of
                                                              WGT -> return ()
                                                              _ -> StateT position >>= (throwError . mkParseError "WGT" "not match pattern: " "" d238_242 ["wrd"])
                                                          let WGT = t696_243
                                                          return ()
                                                          lift (lift (return $ Right h))]
                expressionHsSugar'91_95 = foldl1 mplus [do d239_244 <- get
                                                           t697_245 <- StateT wrd
                                                           case t697_245 of
                                                               WLT -> return ()
                                                               _ -> StateT position >>= (throwError . mkParseError "WLT" "not match pattern: " "" d239_244 ["wrd"])
                                                           let WLT = t697_245
                                                           return ()
                                                           h <- StateT hsExpLam'
                                                           d241_246 <- get
                                                           t699_247 <- StateT wrd
                                                           case t699_247 of
                                                               WGT -> return ()
                                                               _ -> StateT position >>= (throwError . mkParseError "WGT" "not match pattern: " "" d241_246 ["wrd"])
                                                           let WGT = t699_247
                                                           return ()
                                                           lift (lift (return $ Right h))]
                expression92_96 = foldl1 mplus [do l <- StateT nameLeaf_
                                                   e <- StateT expression
                                                   lift (lift (return $ l : e)),
                                                lift (lift (return []))]
                nameLeaf_93_97 = foldl1 mplus [do d244_248 <- get
                                                  t702_249 <- StateT wrd
                                                  case t702_249 of
                                                      WBang -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WBang" "not match pattern: " "" d244_248 ["wrd"])
                                                  let WBang = t702_249
                                                  return ()
                                                  nl <- StateT nameLeafNoCom
                                                  com <- optional139_204 (StateT comForErr)
                                                  lift (lift (return (NAhead $ maybe "" id com,
                                                                      nl))),
                                               do d247_250 <- get
                                                  t705_251 <- StateT wrd
                                                  case t705_251 of
                                                      WAmp -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WAmp" "not match pattern: " "" d247_250 ["wrd"])
                                                  let WAmp = t705_251
                                                  return ()
                                                  nl <- StateT nameLeaf
                                                  lift (lift (return (Ahead, nl))),
                                               do nl <- StateT nameLeaf
                                                  lift (lift (return (Here, nl)))]
                nameLeaf94_98 = foldl1 mplus [do cl <- StateT charLitLs
                                                 lift (lift (return cl)),
                                              do n <- StateT pat1
                                                 com <- optional139_204 (StateT comForErr)
                                                 d253_252 <- get
                                                 t711_253 <- StateT wrd
                                                 case t711_253 of
                                                     WColon -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "WColon" "not match pattern: " "" d253_252 ["wrd"])
                                                 let WColon = t711_253
                                                 return ()
                                                 (rf, p) <- StateT leaf
                                                 lift (lift (return $ Left ((n, maybe "" id com),
                                                                            rf,
                                                                            p))),
                                              do n <- StateT pat1
                                                 com <- optional139_204 (StateT comForErr)
                                                 lift (lift (return $ Left ((n, maybe "" id com),
                                                                            FromVariable Nothing,
                                                                            Nothing)))]
                nameLeafNoCom95_99 = foldl1 mplus [do cl <- StateT charLitLs
                                                      lift (lift (return cl)),
                                                   do n <- StateT pat1
                                                      com <- optional139_204 (StateT comForErr)
                                                      d260_254 <- get
                                                      t718_255 <- StateT wrd
                                                      case t718_255 of
                                                          WColon -> return ()
                                                          _ -> StateT position >>= (throwError . mkParseError "WColon" "not match pattern: " "" d260_254 ["wrd"])
                                                      let WColon = t718_255
                                                      return ()
                                                      (rf, p) <- StateT leaf
                                                      lift (lift (return $ Left ((n,
                                                                                  maybe "" id com),
                                                                                 rf,
                                                                                 p))),
                                                   do n <- StateT pat1
                                                      lift (lift (return $ Left ((n, ""),
                                                                                 FromVariable Nothing,
                                                                                 Nothing)))]
                comForErr96_100 = foldl1 mplus [do d263_256 <- get
                                                   t721_257 <- StateT hsw
                                                   case t721_257 of
                                                       WOComment -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WOComment" "not match pattern: " "" d263_256 ["hsw"])
                                                   let WOComment = t721_257
                                                   return ()
                                                   d264_258 <- get
                                                   t722_259 <- StateT hsw
                                                   case t722_259 of
                                                       (WString _) -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "(WString s)" "not match pattern: " "" d264_258 ["hsw"])
                                                   let (WString s) = t722_259
                                                   return ()
                                                   d265_260 <- get
                                                   t723_261 <- StateT hsw
                                                   case t723_261 of
                                                       WCComment -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WCComment" "not match pattern: " "" d265_260 ["hsw"])
                                                   let WCComment = t723_261
                                                   return ()
                                                   lift (lift (return s))]
                leaf97_101 = foldl1 mplus [do rf <- StateT readFromLs
                                              t <- StateT test
                                              lift (lift (return (rf, Just t))),
                                           do rf <- StateT readFromLs
                                              lift (lift (return (rf, Nothing))),
                                           do t <- StateT test
                                              lift (lift (return (FromVariable Nothing, Just t)))]
                patOp98_102 = foldl1 mplus [do p <- StateT pat
                                               d271_262 <- get
                                               t729_263 <- StateT hsw
                                               case t729_263 of
                                                   (WOpCon _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WOpCon o)" "not match pattern: " "" d271_262 ["hsw"])
                                               let (WOpCon o) = t729_263
                                               return ()
                                               po <- StateT patOp
                                               lift (lift (return $ UInfixP p (mkName o) po)),
                                            do p <- StateT pat
                                               d274_264 <- get
                                               t732_265 <- StateT hsw
                                               case t732_265 of
                                                   WBackQuote -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WBackQuote" "not match pattern: " "" d274_264 ["hsw"])
                                               let WBackQuote = t732_265
                                               return ()
                                               d275_266 <- get
                                               t733_267 <- StateT hsw
                                               case t733_267 of
                                                   (WType [] _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WType [] t)" "not match pattern: " "" d275_266 ["hsw"])
                                               let (WType [] t) = t733_267
                                               return ()
                                               d276_268 <- get
                                               t734_269 <- StateT hsw
                                               case t734_269 of
                                                   WBackQuote -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WBackQuote" "not match pattern: " "" d276_268 ["hsw"])
                                               let WBackQuote = t734_269
                                               return ()
                                               po <- StateT patOp
                                               lift (lift (return $ UInfixP p (mkName t) po)),
                                            do p <- StateT pat
                                               lift (lift (return p))]
                pat99_103 = foldl1 mplus [do d279_270 <- get
                                             t737_271 <- StateT hsw
                                             case t737_271 of
                                                 (WType [] _) -> return ()
                                                 _ -> StateT position >>= (throwError . mkParseError "(WType [] t)" "not match pattern: " "" d279_270 ["hsw"])
                                             let (WType [] t) = t737_271
                                             return ()
                                             ps <- StateT pats
                                             lift (lift (return $ ConP (mkName t) ps)),
                                          do d281_272 <- get
                                             t739_273 <- StateT hsw
                                             case t739_273 of
                                                 WOParen -> return ()
                                                 _ -> StateT position >>= (throwError . mkParseError "WOParen" "not match pattern: " "" d281_272 ["hsw"])
                                             let WOParen = t739_273
                                             return ()
                                             d282_274 <- get
                                             t740_275 <- StateT hsw
                                             case t740_275 of
                                                 (WOpCon _) -> return ()
                                                 _ -> StateT position >>= (throwError . mkParseError "(WOpCon o)" "not match pattern: " "" d282_274 ["hsw"])
                                             let (WOpCon o) = t740_275
                                             return ()
                                             d283_276 <- get
                                             t741_277 <- StateT hsw
                                             case t741_277 of
                                                 WCParen -> return ()
                                                 _ -> StateT position >>= (throwError . mkParseError "WCParen" "not match pattern: " "" d283_276 ["hsw"])
                                             let WCParen = t741_277
                                             return ()
                                             ps <- StateT pats
                                             lift (lift (return $ ConP (mkName o) ps)),
                                          do p <- StateT pat1
                                             lift (lift (return p))]
                pat1100_104 = foldl1 mplus [do d286_278 <- get
                                               t744_279 <- StateT hsw
                                               case t744_279 of
                                                   (WType [] _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WType [] t)" "not match pattern: " "" d286_278 ["hsw"])
                                               let (WType [] t) = t744_279
                                               return ()
                                               lift (lift (return $ ConP (mkName t) [])),
                                            do d287_280 <- get
                                               t745_281 <- StateT hsw
                                               case t745_281 of
                                                   (WVar [] "_") -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WVar [] \"_\")" "not match pattern: " "" d287_280 ["hsw"])
                                               let (WVar [] "_") = t745_281
                                               return ()
                                               lift (lift (return WildP)),
                                            do d288_282 <- get
                                               t746_283 <- StateT hsw
                                               case t746_283 of
                                                   (WVar [] _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WVar [] n)" "not match pattern: " "" d288_282 ["hsw"])
                                               let (WVar [] n) = t746_283
                                               return ()
                                               lift (lift (return $ VarP $ mkName n)),
                                            do d289_284 <- get
                                               t747_285 <- StateT hsw
                                               case t747_285 of
                                                   (WInteger _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WInteger i)" "not match pattern: " "" d289_284 ["hsw"])
                                               let (WInteger i) = t747_285
                                               return ()
                                               lift (lift (return $ LitP (IntegerL i))),
                                            do d290_286 <- get
                                               t748_287 <- StateT hsw
                                               case t748_287 of
                                                   (WOp "-") -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WOp \"-\")" "not match pattern: " "" d290_286 ["hsw"])
                                               let (WOp "-") = t748_287
                                               return ()
                                               d291_288 <- get
                                               t749_289 <- StateT hsw
                                               case t749_289 of
                                                   (WInteger _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WInteger i)" "not match pattern: " "" d291_288 ["hsw"])
                                               let (WInteger i) = t749_289
                                               return ()
                                               lift (lift (return $ LitP (IntegerL $ negate i))),
                                            do d292_290 <- get
                                               t750_291 <- StateT hsw
                                               case t750_291 of
                                                   (WChar _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WChar c)" "not match pattern: " "" d292_290 ["hsw"])
                                               let (WChar c) = t750_291
                                               return ()
                                               lift (lift (return $ LitP $ CharL c)),
                                            do d293_292 <- get
                                               t751_293 <- StateT hsw
                                               case t751_293 of
                                                   (WString _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WString s)" "not match pattern: " "" d293_292 ["hsw"])
                                               let (WString s) = t751_293
                                               return ()
                                               lift (lift (return $ LitP $ StringL s)),
                                            do d294_294 <- get
                                               t752_295 <- StateT hsw
                                               case t752_295 of
                                                   WOParen -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WOParen" "not match pattern: " "" d294_294 ["hsw"])
                                               let WOParen = t752_295
                                               return ()
                                               p <- StateT patList
                                               d296_296 <- get
                                               t754_297 <- StateT hsw
                                               case t754_297 of
                                                   WCParen -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WCParen" "not match pattern: " "" d296_296 ["hsw"])
                                               let WCParen = t754_297
                                               return ()
                                               lift (lift (return $ TupP p)),
                                            do d297_298 <- get
                                               t755_299 <- StateT hsw
                                               case t755_299 of
                                                   WOBracket -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WOBracket" "not match pattern: " "" d297_298 ["hsw"])
                                               let WOBracket = t755_299
                                               return ()
                                               p <- StateT patList
                                               d299_300 <- get
                                               t757_301 <- StateT hsw
                                               case t757_301 of
                                                   WCBracket -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WCBracket" "not match pattern: " "" d299_300 ["hsw"])
                                               let WCBracket = t757_301
                                               return ()
                                               lift (lift (return $ ListP p)),
                                            do d300_302 <- get
                                               t758_303 <- StateT hsw
                                               case t758_303 of
                                                   WOParen -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WOParen" "not match pattern: " "" d300_302 ["hsw"])
                                               let WOParen = t758_303
                                               return ()
                                               p <- StateT pat
                                               d302_304 <- get
                                               t760_305 <- StateT hsw
                                               case t760_305 of
                                                   WCParen -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WCParen" "not match pattern: " "" d302_304 ["hsw"])
                                               let WCParen = t760_305
                                               return ()
                                               lift (lift (return p)),
                                            do d303_306 <- get
                                               t761_307 <- StateT hsw
                                               case t761_307 of
                                                   (WOp "!") -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WOp \"!\")" "not match pattern: " "" d303_306 ["hsw"])
                                               let (WOp "!") = t761_307
                                               return ()
                                               p <- StateT pat
                                               lift (lift (return $ BangP p))]
                patList101_105 = foldl1 mplus [do p <- StateT patOp
                                                  d306_308 <- get
                                                  t764_309 <- StateT hsw
                                                  case t764_309 of
                                                      WComma -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WComma" "not match pattern: " "" d306_308 ["hsw"])
                                                  let WComma = t764_309
                                                  return ()
                                                  ps <- StateT patList
                                                  lift (lift (return $ p : ps)),
                                               do p <- StateT patOp
                                                  lift (lift (return [p])),
                                               lift (lift (return []))]
                pats102_106 = foldl1 mplus [do p <- StateT pat
                                               ps <- StateT pats
                                               lift (lift (return $ p : ps)),
                                            lift (lift (return []))]
                charLitLs103_107 = foldl1 mplus [do d311_310 <- get
                                                    t769_311 <- StateT hsw
                                                    case t769_311 of
                                                        (WChar _) -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "(WChar c)" "not match pattern: " "" d311_310 ["hsw"])
                                                    let (WChar c) = t769_311
                                                    return ()
                                                    d312_312 <- get
                                                    t770_313 <- StateT wrd
                                                    case t770_313 of
                                                        WAsterisk -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "WAsterisk" "not match pattern: " "" d312_312 ["wrd"])
                                                    let WAsterisk = t770_313
                                                    return ()
                                                    lift (lift (return $ Right (c, List))),
                                                 do d313_314 <- get
                                                    t771_315 <- StateT hsw
                                                    case t771_315 of
                                                        (WChar _) -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "(WChar c)" "not match pattern: " "" d313_314 ["hsw"])
                                                    let (WChar c) = t771_315
                                                    return ()
                                                    d314_316 <- get
                                                    t772_317 <- StateT wrd
                                                    case t772_317 of
                                                        WPlus -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "WPlus" "not match pattern: " "" d314_316 ["wrd"])
                                                    let WPlus = t772_317
                                                    return ()
                                                    lift (lift (return $ Right (c, List1))),
                                                 do d315_318 <- get
                                                    t773_319 <- StateT hsw
                                                    case t773_319 of
                                                        (WChar _) -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "(WChar c)" "not match pattern: " "" d315_318 ["hsw"])
                                                    let (WChar c) = t773_319
                                                    return ()
                                                    d316_320 <- get
                                                    t774_321 <- StateT wrd
                                                    case t774_321 of
                                                        WQuestion -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "WQuestion" "not match pattern: " "" d316_320 ["wrd"])
                                                    let WQuestion = t774_321
                                                    return ()
                                                    lift (lift (return $ Right (c, Optional)))]
                readFromLs104_108 = foldl1 mplus [do rf <- StateT readFrom
                                                     d318_322 <- get
                                                     t776_323 <- StateT wrd
                                                     case t776_323 of
                                                         WAsterisk -> return ()
                                                         _ -> StateT position >>= (throwError . mkParseError "WAsterisk" "not match pattern: " "" d318_322 ["wrd"])
                                                     let WAsterisk = t776_323
                                                     return ()
                                                     lift (lift (return $ FromL List rf)),
                                                  do rf <- StateT readFrom
                                                     d320_324 <- get
                                                     t778_325 <- StateT wrd
                                                     case t778_325 of
                                                         WPlus -> return ()
                                                         _ -> StateT position >>= (throwError . mkParseError "WPlus" "not match pattern: " "" d320_324 ["wrd"])
                                                     let WPlus = t778_325
                                                     return ()
                                                     lift (lift (return $ FromL List1 rf)),
                                                  do rf <- StateT readFrom
                                                     d322_326 <- get
                                                     t780_327 <- StateT wrd
                                                     case t780_327 of
                                                         WQuestion -> return ()
                                                         _ -> StateT position >>= (throwError . mkParseError "WQuestion" "not match pattern: " "" d322_326 ["wrd"])
                                                     let WQuestion = t780_327
                                                     return ()
                                                     lift (lift (return $ FromL Optional rf)),
                                                  do rf <- StateT readFrom
                                                     lift (lift (return rf))]
                readFrom105_109 = foldl1 mplus [do d324_328 <- get
                                                   t782_329 <- StateT wrd
                                                   case t782_329 of
                                                       (WSymbol _) -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "(WSymbol v)" "not match pattern: " "" d324_328 ["wrd"])
                                                   let (WSymbol v) = t782_329
                                                   return ()
                                                   lift (lift (return $ FromVariable $ Just v)),
                                                do d325_330 <- get
                                                   t783_331 <- StateT wrd
                                                   case t783_331 of
                                                       WOParen -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WOParen" "not match pattern: " "" d325_330 ["wrd"])
                                                   let WOParen = t783_331
                                                   return ()
                                                   s <- StateT selection
                                                   d327_332 <- get
                                                   t785_333 <- StateT wrd
                                                   case t785_333 of
                                                       WCParen -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WCParen" "not match pattern: " "" d327_332 ["wrd"])
                                                   let WCParen = t785_333
                                                   return ()
                                                   lift (lift (return $ FromSelection s)),
                                                do e <- StateT expressionHsSugar'
                                                   lift (lift (return $ FromSelection [e]))]
                test106_110 = foldl1 mplus [do d329_334 <- get
                                               t787_335 <- StateT wrd
                                               case t787_335 of
                                                   WOBracket -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WOBracket" "not match pattern: " "" d329_334 ["wrd"])
                                               let WOBracket = t787_335
                                               return ()
                                               h <- StateT hsExpLam
                                               com <- optional139_204 (StateT comForErr)
                                               d332_336 <- get
                                               t790_337 <- StateT wrd
                                               case t790_337 of
                                                   WCBracket -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WCBracket" "not match pattern: " "" d332_336 ["wrd"])
                                               let WCBracket = t790_337
                                               return ()
                                               lift (lift (return (h, maybe "" id com)))]
                hsExpLam107_111 = foldl1 mplus [do d333_338 <- get
                                                   t791_339 <- StateT hsw
                                                   case t791_339 of
                                                       (WOp "\\") -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "(WOp \"\\\\\")" "not match pattern: " "" d333_338 ["hsw"])
                                                   let (WOp "\\") = t791_339
                                                   return ()
                                                   ps <- StateT pats
                                                   d335_340 <- get
                                                   t793_341 <- StateT hsw
                                                   case t793_341 of
                                                       WRightArrow -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WRightArrow" "not match pattern: " "" d335_340 ["hsw"])
                                                   let WRightArrow = t793_341
                                                   return ()
                                                   e <- StateT hsExpTyp
                                                   lift (lift (return $ LamE ps e)),
                                                do e <- StateT hsExpTyp
                                                   lift (lift (return e))]
                hsExpTyp108_112 = foldl1 mplus [do eo <- StateT hsExpOp
                                                   d339_342 <- get
                                                   t797_343 <- StateT hsw
                                                   case t797_343 of
                                                       WTypeDef -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WTypeDef" "not match pattern: " "" d339_342 ["hsw"])
                                                   let WTypeDef = t797_343
                                                   return ()
                                                   t <- StateT hsTypeArr
                                                   lift (lift (return $ SigE eo t)),
                                                do eo <- StateT hsExpOp
                                                   lift (lift (return eo))]
                hsExpOp109_113 = foldl1 mplus [do l <- StateT hsExp
                                                  o <- StateT hsOp
                                                  r <- StateT hsExpOp
                                                  lift (lift (return $ UInfixE (l id) o r)),
                                               do e <- StateT hsExp
                                                  lift (lift (return $ e id))]
                hsOp110_114 = foldl1 mplus [do d346_344 <- get
                                               t804_345 <- StateT hsw
                                               case t804_345 of
                                                   (WOp _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WOp op)" "not match pattern: " "" d346_344 ["hsw"])
                                               let (WOp op) = t804_345
                                               return ()
                                               lift (lift (return $ VarE $ mkName op)),
                                            do d347_346 <- get
                                               t805_347 <- StateT hsw
                                               case t805_347 of
                                                   (WOpCon _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WOpCon op)" "not match pattern: " "" d347_346 ["hsw"])
                                               let (WOpCon op) = t805_347
                                               return ()
                                               lift (lift (return $ ConE $ mkName op)),
                                            do d348_348 <- get
                                               t806_349 <- StateT hsw
                                               case t806_349 of
                                                   WBackQuote -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WBackQuote" "not match pattern: " "" d348_348 ["hsw"])
                                               let WBackQuote = t806_349
                                               return ()
                                               d349_350 <- get
                                               t807_351 <- StateT hsw
                                               case t807_351 of
                                                   (WVar [] _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WVar [] v)" "not match pattern: " "" d349_350 ["hsw"])
                                               let (WVar [] v) = t807_351
                                               return ()
                                               d350_352 <- get
                                               t808_353 <- StateT hsw
                                               case t808_353 of
                                                   WBackQuote -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WBackQuote" "not match pattern: " "" d350_352 ["hsw"])
                                               let WBackQuote = t808_353
                                               return ()
                                               lift (lift (return $ VarE $ mkName v)),
                                            do d351_354 <- get
                                               t809_355 <- StateT hsw
                                               case t809_355 of
                                                   WBackQuote -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WBackQuote" "not match pattern: " "" d351_354 ["hsw"])
                                               let WBackQuote = t809_355
                                               return ()
                                               d352_356 <- get
                                               t810_357 <- StateT hsw
                                               case t810_357 of
                                                   (WType [] _) -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "(WType [] t)" "not match pattern: " "" d352_356 ["hsw"])
                                               let (WType [] t) = t810_357
                                               return ()
                                               d353_358 <- get
                                               t811_359 <- StateT hsw
                                               case t811_359 of
                                                   WBackQuote -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "WBackQuote" "not match pattern: " "" d353_358 ["hsw"])
                                               let WBackQuote = t811_359
                                               return ()
                                               lift (lift (return $ ConE $ mkName t))]
                hsExpLam'111_115 = foldl1 mplus [do d354_360 <- get
                                                    t812_361 <- StateT hsw
                                                    case t812_361 of
                                                        (WOp "\\") -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "(WOp \"\\\\\")" "not match pattern: " "" d354_360 ["hsw"])
                                                    let (WOp "\\") = t812_361
                                                    return ()
                                                    ps <- StateT pats
                                                    d356_362 <- get
                                                    t814_363 <- StateT hsw
                                                    case t814_363 of
                                                        WRightArrow -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "WRightArrow" "not match pattern: " "" d356_362 ["hsw"])
                                                    let WRightArrow = t814_363
                                                    return ()
                                                    e <- StateT hsExpTyp'
                                                    lift (lift (return $ LamE ps e)),
                                                 do e <- StateT hsExpTyp'
                                                    lift (lift (return e))]
                hsExpTyp'112_116 = foldl1 mplus [do eo <- StateT hsExpOp'
                                                    d360_364 <- get
                                                    t818_365 <- StateT hsw
                                                    case t818_365 of
                                                        WTypeDef -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "WTypeDef" "not match pattern: " "" d360_364 ["hsw"])
                                                    let WTypeDef = t818_365
                                                    return ()
                                                    t <- StateT hsTypeArr
                                                    lift (lift (return $ SigE eo t)),
                                                 do eo <- StateT hsExpOp'
                                                    lift (lift (return eo))]
                hsExpOp'113_117 = foldl1 mplus [do l <- StateT hsExp
                                                   o <- StateT hsOp'
                                                   r <- StateT hsExpOp'
                                                   lift (lift (return $ UInfixE (l id) o r)),
                                                do e <- StateT hsExp
                                                   lift (lift (return $ e id))]
                hsOp'114_118 = foldl1 mplus [do d367_366 <- get
                                                t825_367 <- StateT hsw
                                                case t825_367 of
                                                    (WOp _) -> return ()
                                                    _ -> StateT position >>= (throwError . mkParseError "(WOp op)" "not match pattern: " "" d367_366 ["hsw"])
                                                let (WOp op) = t825_367
                                                return ()
                                                b1274_368 <- lift (lift (return $ head op /= '>'))
                                                unless b1274_368 (StateT position >>= (throwError . mkParseError "return $ head op /= '>'" "not match: " "" d367_366 ["hsw"]))
                                                lift (lift (return $ VarE $ mkName op)),
                                             do d368_369 <- get
                                                t826_370 <- StateT hsw
                                                case t826_370 of
                                                    (WOpCon _) -> return ()
                                                    _ -> StateT position >>= (throwError . mkParseError "(WOpCon op)" "not match pattern: " "" d368_369 ["hsw"])
                                                let (WOpCon op) = t826_370
                                                return ()
                                                lift (lift (return $ ConE $ mkName op)),
                                             do d369_371 <- get
                                                t827_372 <- StateT hsw
                                                case t827_372 of
                                                    WBackQuote -> return ()
                                                    _ -> StateT position >>= (throwError . mkParseError "WBackQuote" "not match pattern: " "" d369_371 ["hsw"])
                                                let WBackQuote = t827_372
                                                return ()
                                                v <- StateT var
                                                d371_373 <- get
                                                t829_374 <- StateT hsw
                                                case t829_374 of
                                                    WBackQuote -> return ()
                                                    _ -> StateT position >>= (throwError . mkParseError "WBackQuote" "not match pattern: " "" d371_373 ["hsw"])
                                                let WBackQuote = t829_374
                                                return ()
                                                lift (lift (return $ VarE $ mkName v)),
                                             do d372_375 <- get
                                                t830_376 <- StateT hsw
                                                case t830_376 of
                                                    WBackQuote -> return ()
                                                    _ -> StateT position >>= (throwError . mkParseError "WBackQuote" "not match pattern: " "" d372_375 ["hsw"])
                                                let WBackQuote = t830_376
                                                return ()
                                                t <- StateT typ
                                                d374_377 <- get
                                                t832_378 <- StateT hsw
                                                case t832_378 of
                                                    WBackQuote -> return ()
                                                    _ -> StateT position >>= (throwError . mkParseError "WBackQuote" "not match pattern: " "" d374_377 ["hsw"])
                                                let WBackQuote = t832_378
                                                return ()
                                                lift (lift (return $ ConE $ mkName t))]
                hsExp115_119 = foldl1 mplus [do e <- StateT hsExp1
                                                h <- StateT hsExp
                                                lift (lift (return (\f -> h (f e `AppE`)))),
                                             do e <- StateT hsExp1
                                                lift (lift (return (\f -> f e)))]
                hsExp1116_120 = foldl1 mplus [do d378_379 <- get
                                                 t836_380 <- StateT hsw
                                                 case t836_380 of
                                                     WOParen -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "WOParen" "not match pattern: " "" d378_379 ["hsw"])
                                                 let WOParen = t836_380
                                                 return ()
                                                 l <- optional139_204 (StateT hsExpOp)
                                                 o <- StateT hsOp
                                                 r <- optional139_204 (StateT hsExpOp)
                                                 d382_381 <- get
                                                 t840_382 <- StateT hsw
                                                 case t840_382 of
                                                     WCParen -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "WCParen" "not match pattern: " "" d382_381 ["hsw"])
                                                 let WCParen = t840_382
                                                 return ()
                                                 lift (lift (return $ InfixE l o r)),
                                              do d383_383 <- get
                                                 t841_384 <- StateT hsw
                                                 case t841_384 of
                                                     WOParen -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "WOParen" "not match pattern: " "" d383_383 ["hsw"])
                                                 let WOParen = t841_384
                                                 return ()
                                                 et <- StateT hsExpTpl
                                                 d385_385 <- get
                                                 t843_386 <- StateT hsw
                                                 case t843_386 of
                                                     WCParen -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "WCParen" "not match pattern: " "" d385_385 ["hsw"])
                                                 let WCParen = t843_386
                                                 return ()
                                                 lift (lift (return $ TupE et)),
                                              do d386_387 <- get
                                                 t844_388 <- StateT hsw
                                                 case t844_388 of
                                                     WOBracket -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "WOBracket" "not match pattern: " "" d386_387 ["hsw"])
                                                 let WOBracket = t844_388
                                                 return ()
                                                 et <- StateT hsExpTpl
                                                 d388_389 <- get
                                                 t846_390 <- StateT hsw
                                                 case t846_390 of
                                                     WCBracket -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "WCBracket" "not match pattern: " "" d388_389 ["hsw"])
                                                 let WCBracket = t846_390
                                                 return ()
                                                 lift (lift (return $ ListE et)),
                                              do d389_391 <- get
                                                 t847_392 <- StateT hsw
                                                 case t847_392 of
                                                     WOBracket -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "WOBracket" "not match pattern: " "" d389_391 ["hsw"])
                                                 let WOBracket = t847_392
                                                 return ()
                                                 b <- StateT hsExpOp
                                                 d391_393 <- get
                                                 t849_394 <- StateT hsw
                                                 case t849_394 of
                                                     WDotDot -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "WDotDot" "not match pattern: " "" d391_393 ["hsw"])
                                                 let WDotDot = t849_394
                                                 return ()
                                                 e <- StateT hsExpOp
                                                 d393_395 <- get
                                                 t851_396 <- StateT hsw
                                                 case t851_396 of
                                                     WCBracket -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "WCBracket" "not match pattern: " "" d393_395 ["hsw"])
                                                 let WCBracket = t851_396
                                                 return ()
                                                 lift (lift (return $ ArithSeqE $ FromToR b e)),
                                              do d394_397 <- get
                                                 t852_398 <- StateT hsw
                                                 case t852_398 of
                                                     (WVar [] _) -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "(WVar [] v)" "not match pattern: " "" d394_397 ["hsw"])
                                                 let (WVar [] v) = t852_398
                                                 return ()
                                                 lift (lift (return $ VarE $ mkName v)),
                                              do d395_399 <- get
                                                 t853_400 <- StateT hsw
                                                 case t853_400 of
                                                     (WType [] _) -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "(WType [] t)" "not match pattern: " "" d395_399 ["hsw"])
                                                 let (WType [] t) = t853_400
                                                 return ()
                                                 lift (lift (return $ ConE $ mkName t)),
                                              do d396_401 <- get
                                                 t854_402 <- StateT hsw
                                                 case t854_402 of
                                                     (WInteger _) -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "(WInteger i)" "not match pattern: " "" d396_401 ["hsw"])
                                                 let (WInteger i) = t854_402
                                                 return ()
                                                 lift (lift (return $ LitE $ integerL i)),
                                              do d397_403 <- get
                                                 t855_404 <- StateT hsw
                                                 case t855_404 of
                                                     (WChar _) -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "(WChar c)" "not match pattern: " "" d397_403 ["hsw"])
                                                 let (WChar c) = t855_404
                                                 return ()
                                                 lift (lift (return $ LitE $ charL c)),
                                              do d398_405 <- get
                                                 t856_406 <- StateT hsw
                                                 case t856_406 of
                                                     (WString _) -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "(WString s)" "not match pattern: " "" d398_405 ["hsw"])
                                                 let (WString s) = t856_406
                                                 return ()
                                                 lift (lift (return $ LitE $ stringL s)),
                                              do d399_407 <- get
                                                 t857_408 <- StateT hsw
                                                 case t857_408 of
                                                     (WOp "-") -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "(WOp \"-\")" "not match pattern: " "" d399_407 ["hsw"])
                                                 let (WOp "-") = t857_408
                                                 return ()
                                                 e <- StateT hsExp1
                                                 lift (lift (return $ AppE (VarE $ mkName "negate") e))]
                hsExpTpl117_121 = foldl1 mplus [do e <- StateT hsExpLam
                                                   d402_409 <- get
                                                   t860_410 <- StateT hsw
                                                   case t860_410 of
                                                       WComma -> return ()
                                                       _ -> StateT position >>= (throwError . mkParseError "WComma" "not match pattern: " "" d402_409 ["hsw"])
                                                   let WComma = t860_410
                                                   return ()
                                                   et <- StateT hsExpTpl
                                                   lift (lift (return $ e : et)),
                                                do e <- StateT hsExpLam
                                                   lift (lift (return [e])),
                                                lift (lift (return []))]
                hsTypeArr118_122 = foldl1 mplus [do l <- StateT hsType
                                                    d406_411 <- get
                                                    t864_412 <- StateT hsw
                                                    case t864_412 of
                                                        WRightArrow -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "WRightArrow" "not match pattern: " "" d406_411 ["hsw"])
                                                    let WRightArrow = t864_412
                                                    return ()
                                                    r <- StateT hsTypeArr
                                                    lift (lift (return $ AppT (AppT ArrowT $ l id) r)),
                                                 do t <- StateT hsType
                                                    lift (lift (return $ t id))]
                hsType119_123 = foldl1 mplus [do t <- StateT hsType1
                                                 ts <- StateT hsType
                                                 lift (lift (return $ (\f -> ts (f t `AppT`)))),
                                              do t <- StateT hsType1
                                                 lift (lift (return ($ t)))]
                hsType1120_124 = foldl1 mplus [do d412_413 <- get
                                                  t870_414 <- StateT hsw
                                                  case t870_414 of
                                                      WOBracket -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WOBracket" "not match pattern: " "" d412_413 ["hsw"])
                                                  let WOBracket = t870_414
                                                  return ()
                                                  d413_415 <- get
                                                  t871_416 <- StateT hsw
                                                  case t871_416 of
                                                      WCBracket -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WCBracket" "not match pattern: " "" d413_415 ["hsw"])
                                                  let WCBracket = t871_416
                                                  return ()
                                                  lift (lift (return ListT)),
                                               do d414_417 <- get
                                                  t872_418 <- StateT hsw
                                                  case t872_418 of
                                                      WOBracket -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WOBracket" "not match pattern: " "" d414_417 ["hsw"])
                                                  let WOBracket = t872_418
                                                  return ()
                                                  t <- StateT hsTypeArr
                                                  d416_419 <- get
                                                  t874_420 <- StateT hsw
                                                  case t874_420 of
                                                      WCBracket -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WCBracket" "not match pattern: " "" d416_419 ["hsw"])
                                                  let WCBracket = t874_420
                                                  return ()
                                                  lift (lift (return $ ListT `AppT` t)),
                                               do d417_421 <- get
                                                  t875_422 <- StateT hsw
                                                  case t875_422 of
                                                      WOParen -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WOParen" "not match pattern: " "" d417_421 ["hsw"])
                                                  let WOParen = t875_422
                                                  return ()
                                                  tt <- StateT hsTypeTpl
                                                  d419_423 <- get
                                                  t877_424 <- StateT hsw
                                                  case t877_424 of
                                                      WCParen -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WCParen" "not match pattern: " "" d419_423 ["hsw"])
                                                  let WCParen = t877_424
                                                  return ()
                                                  lift (lift (return $ foldl AppT (TupleT $ length tt) tt)),
                                               do d420_425 <- get
                                                  t878_426 <- StateT hsw
                                                  case t878_426 of
                                                      (WType [] _) -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "(WType [] t)" "not match pattern: " "" d420_425 ["hsw"])
                                                  let (WType [] t) = t878_426
                                                  return ()
                                                  lift (lift (return $ ConT $ mkName t)),
                                               do d421_427 <- get
                                                  t879_428 <- StateT hsw
                                                  case t879_428 of
                                                      WOParen -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WOParen" "not match pattern: " "" d421_427 ["hsw"])
                                                  let WOParen = t879_428
                                                  return ()
                                                  d422_429 <- get
                                                  t880_430 <- StateT hsw
                                                  case t880_430 of
                                                      WRightArrow -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WRightArrow" "not match pattern: " "" d422_429 ["hsw"])
                                                  let WRightArrow = t880_430
                                                  return ()
                                                  d423_431 <- get
                                                  t881_432 <- StateT hsw
                                                  case t881_432 of
                                                      WCParen -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "WCParen" "not match pattern: " "" d423_431 ["hsw"])
                                                  let WCParen = t881_432
                                                  return ()
                                                  lift (lift (return ArrowT))]
                hsTypeTpl121_125 = foldl1 mplus [do t <- StateT hsTypeArr
                                                    d425_433 <- get
                                                    t883_434 <- StateT hsw
                                                    case t883_434 of
                                                        WComma -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "WComma" "not match pattern: " "" d425_433 ["hsw"])
                                                    let WComma = t883_434
                                                    return ()
                                                    tt <- StateT hsTypeTpl
                                                    lift (lift (return $ t : tt)),
                                                 do t <- StateT hsTypeArr
                                                    lift (lift (return [t])),
                                                 lift (lift (return []))]
                wrd122_126 = foldl1 mplus [do w <- StateT word
                                              _ <- list140_145 (StateT space)
                                              return ()
                                              lift (lift (return w)),
                                           do _ <- StateT semiColon
                                              return ()
                                              _ <- list140_145 (StateT space')
                                              return ()
                                              lift (lift (return WSemiColon))]
                hsw123_127 = foldl1 mplus [do w <- StateT hsWord
                                              _ <- list140_145 (StateT space)
                                              return ()
                                              lift (lift (return w))]
                word124_128 = foldl1 mplus [do v <- list1141_435 (foldl1 mplus [do d435_436 <- get
                                                                                   t893_437 <- StateT char
                                                                                   let c1506_143 = t893_437
                                                                                   b1342_438 <- return (((||) <$> isAlphaNum <*> (`elem` "_'")) c1506_143)
                                                                                   unless b1342_438 (StateT position >>= (throwError . mkParseError "((||) <$> isAlphaNum <*> (`elem` \"_'\")) c1506_0" "not match: " "" d435_436 ["char"]))
                                                                                   return c1506_143])
                                               lift (lift (return $ WSymbol v)),
                                            do d436_439 <- get
                                               t894_440 <- StateT char
                                               case t894_440 of
                                                   '!' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'!'" "not match pattern: " "" d436_439 ["char"])
                                               let '!' = t894_440
                                               return ()
                                               lift (lift (return WBang)),
                                            do d437_441 <- get
                                               t895_442 <- StateT char
                                               case t895_442 of
                                                   '&' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'&'" "not match pattern: " "" d437_441 ["char"])
                                               let '&' = t895_442
                                               return ()
                                               lift (lift (return WAmp)),
                                            do d438_443 <- get
                                               t896_444 <- StateT char
                                               case t896_444 of
                                                   '*' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'*'" "not match pattern: " "" d438_443 ["char"])
                                               let '*' = t896_444
                                               return ()
                                               lift (lift (return WAsterisk)),
                                            do d439_445 <- get
                                               t897_446 <- StateT char
                                               case t897_446 of
                                                   '+' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'+'" "not match pattern: " "" d439_445 ["char"])
                                               let '+' = t897_446
                                               return ()
                                               lift (lift (return WPlus)),
                                            do d440_447 <- get
                                               t898_448 <- StateT char
                                               case t898_448 of
                                                   '?' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'?'" "not match pattern: " "" d440_447 ["char"])
                                               let '?' = t898_448
                                               return ()
                                               lift (lift (return WQuestion)),
                                            do d441_449 <- get
                                               t899_450 <- StateT char
                                               case t899_450 of
                                                   '=' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'='" "not match pattern: " "" d441_449 ["char"])
                                               let '=' = t899_450
                                               return ()
                                               lift (lift (return WEqual)),
                                            do d442_451 <- get
                                               t900_452 <- StateT char
                                               case t900_452 of
                                                   '/' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'/'" "not match pattern: " "" d442_451 ["char"])
                                               let '/' = t900_452
                                               return ()
                                               lift (lift (return WSlash)),
                                            do d443_453 <- get
                                               t901_454 <- StateT char
                                               case t901_454 of
                                                   ':' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "':'" "not match pattern: " "" d443_453 ["char"])
                                               let ':' = t901_454
                                               return ()
                                               lift (lift (return WColon)),
                                            do d444_455 <- get
                                               t902_456 <- StateT char
                                               case t902_456 of
                                                   '<' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'<'" "not match pattern: " "" d444_455 ["char"])
                                               let '<' = t902_456
                                               return ()
                                               lift (lift (return WLT)),
                                            do d445_457 <- get
                                               t903_458 <- StateT char
                                               case t903_458 of
                                                   '>' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'>'" "not match pattern: " "" d445_457 ["char"])
                                               let '>' = t903_458
                                               return ()
                                               lift (lift (return WGT)),
                                            do b <- StateT bras
                                               lift (lift (return b))]
                hsWord125_129 = foldl1 mplus [do d447_459 <- get
                                                 t905_460 <- StateT char
                                                 case t905_460 of
                                                     'm' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'m'" "not match pattern: " "" d447_459 ["char"])
                                                 let 'm' = t905_460
                                                 return ()
                                                 d448_461 <- get
                                                 t906_462 <- StateT char
                                                 case t906_462 of
                                                     'o' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'o'" "not match pattern: " "" d448_461 ["char"])
                                                 let 'o' = t906_462
                                                 return ()
                                                 d449_463 <- get
                                                 t907_464 <- StateT char
                                                 case t907_464 of
                                                     'd' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'d'" "not match pattern: " "" d449_463 ["char"])
                                                 let 'd' = t907_464
                                                 return ()
                                                 d450_465 <- get
                                                 t908_466 <- StateT char
                                                 case t908_466 of
                                                     'u' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'u'" "not match pattern: " "" d450_465 ["char"])
                                                 let 'u' = t908_466
                                                 return ()
                                                 d451_467 <- get
                                                 t909_468 <- StateT char
                                                 case t909_468 of
                                                     'l' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'l'" "not match pattern: " "" d451_467 ["char"])
                                                 let 'l' = t909_468
                                                 return ()
                                                 d452_469 <- get
                                                 t910_470 <- StateT char
                                                 case t910_470 of
                                                     'e' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'e'" "not match pattern: " "" d452_469 ["char"])
                                                 let 'e' = t910_470
                                                 return ()
                                                 lift (lift (return $ WModule)),
                                              do d453_471 <- get
                                                 t911_472 <- StateT char
                                                 case t911_472 of
                                                     'w' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'w'" "not match pattern: " "" d453_471 ["char"])
                                                 let 'w' = t911_472
                                                 return ()
                                                 d454_473 <- get
                                                 t912_474 <- StateT char
                                                 case t912_474 of
                                                     'h' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'h'" "not match pattern: " "" d454_473 ["char"])
                                                 let 'h' = t912_474
                                                 return ()
                                                 d455_475 <- get
                                                 t913_476 <- StateT char
                                                 case t913_476 of
                                                     'e' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'e'" "not match pattern: " "" d455_475 ["char"])
                                                 let 'e' = t913_476
                                                 return ()
                                                 d456_477 <- get
                                                 t914_478 <- StateT char
                                                 case t914_478 of
                                                     'r' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'r'" "not match pattern: " "" d456_477 ["char"])
                                                 let 'r' = t914_478
                                                 return ()
                                                 d457_479 <- get
                                                 t915_480 <- StateT char
                                                 case t915_480 of
                                                     'e' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'e'" "not match pattern: " "" d457_479 ["char"])
                                                 let 'e' = t915_480
                                                 return ()
                                                 lift (lift (return $ WWhere)),
                                              do d458_481 <- get
                                                 t916_482 <- StateT char
                                                 case t916_482 of
                                                     'i' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'i'" "not match pattern: " "" d458_481 ["char"])
                                                 let 'i' = t916_482
                                                 return ()
                                                 d459_483 <- get
                                                 t917_484 <- StateT char
                                                 case t917_484 of
                                                     'm' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'m'" "not match pattern: " "" d459_483 ["char"])
                                                 let 'm' = t917_484
                                                 return ()
                                                 d460_485 <- get
                                                 t918_486 <- StateT char
                                                 case t918_486 of
                                                     'p' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'p'" "not match pattern: " "" d460_485 ["char"])
                                                 let 'p' = t918_486
                                                 return ()
                                                 d461_487 <- get
                                                 t919_488 <- StateT char
                                                 case t919_488 of
                                                     'o' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'o'" "not match pattern: " "" d461_487 ["char"])
                                                 let 'o' = t919_488
                                                 return ()
                                                 d462_489 <- get
                                                 t920_490 <- StateT char
                                                 case t920_490 of
                                                     'r' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'r'" "not match pattern: " "" d462_489 ["char"])
                                                 let 'r' = t920_490
                                                 return ()
                                                 d463_491 <- get
                                                 t921_492 <- StateT char
                                                 case t921_492 of
                                                     't' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'t'" "not match pattern: " "" d463_491 ["char"])
                                                 let 't' = t921_492
                                                 return ()
                                                 lift (lift (return $ WImport)),
                                              do d464_493 <- get
                                                 t922_494 <- StateT char
                                                 case t922_494 of
                                                     '[' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'['" "not match pattern: " "" d464_493 ["char"])
                                                 let '[' = t922_494
                                                 return ()
                                                 v <- StateT var
                                                 d466_495 <- get
                                                 t924_496 <- StateT char
                                                 case t924_496 of
                                                     '|' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'|'" "not match pattern: " "" d466_495 ["char"])
                                                 let '|' = t924_496
                                                 return ()
                                                 lift (lift (return $ WOQuasiQuote v)),
                                              do d467_497 <- get
                                                 t925_498 <- StateT char
                                                 case t925_498 of
                                                     '|' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'|'" "not match pattern: " "" d467_497 ["char"])
                                                 let '|' = t925_498
                                                 return ()
                                                 d468_499 <- get
                                                 t926_500 <- StateT char
                                                 case t926_500 of
                                                     ']' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "']'" "not match pattern: " "" d468_499 ["char"])
                                                 let ']' = t926_500
                                                 return ()
                                                 lift (lift (return WCQuasiQuote)),
                                              do d469_501 <- get
                                                 t927_502 <- StateT char
                                                 case t927_502 of
                                                     ':' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "':'" "not match pattern: " "" d469_501 ["char"])
                                                 let ':' = t927_502
                                                 return ()
                                                 d470_503 <- get
                                                 t928_504 <- StateT char
                                                 case t928_504 of
                                                     ':' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "':'" "not match pattern: " "" d470_503 ["char"])
                                                 let ':' = t928_504
                                                 return ()
                                                 lift (lift (return WTypeDef)),
                                              do d471_505 <- get
                                                 t929_506 <- StateT char
                                                 case t929_506 of
                                                     '-' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'-'" "not match pattern: " "" d471_505 ["char"])
                                                 let '-' = t929_506
                                                 return ()
                                                 d472_507 <- get
                                                 t930_508 <- StateT char
                                                 case t930_508 of
                                                     '>' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'>'" "not match pattern: " "" d472_507 ["char"])
                                                 let '>' = t930_508
                                                 return ()
                                                 lift (lift (return WRightArrow)),
                                              do d473_509 <- get
                                                 t931_510 <- StateT char
                                                 case t931_510 of
                                                     '.' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'.'" "not match pattern: " "" d473_509 ["char"])
                                                 let '.' = t931_510
                                                 return ()
                                                 d474_511 <- get
                                                 t932_512 <- StateT char
                                                 case t932_512 of
                                                     '.' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'.'" "not match pattern: " "" d474_511 ["char"])
                                                 let '.' = t932_512
                                                 return ()
                                                 lift (lift (return WDotDot)),
                                              do d475_513 <- get
                                                 t933_514 <- StateT char
                                                 case t933_514 of
                                                     '{' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'{'" "not match pattern: " "" d475_513 ["char"])
                                                 let '{' = t933_514
                                                 return ()
                                                 d476_515 <- get
                                                 t934_516 <- StateT char
                                                 case t934_516 of
                                                     '-' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'-'" "not match pattern: " "" d476_515 ["char"])
                                                 let '-' = t934_516
                                                 return ()
                                                 d477_517 <- get
                                                 t935_518 <- StateT char
                                                 case t935_518 of
                                                     '#' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'#'" "not match pattern: " "" d477_517 ["char"])
                                                 let '#' = t935_518
                                                 return ()
                                                 lift (lift (return WOComment)),
                                              do d478_519 <- get
                                                 t936_520 <- StateT char
                                                 case t936_520 of
                                                     '#' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'#'" "not match pattern: " "" d478_519 ["char"])
                                                 let '#' = t936_520
                                                 return ()
                                                 d479_521 <- get
                                                 t937_522 <- StateT char
                                                 case t937_522 of
                                                     '-' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'-'" "not match pattern: " "" d479_521 ["char"])
                                                 let '-' = t937_522
                                                 return ()
                                                 d480_523 <- get
                                                 t938_524 <- StateT char
                                                 case t938_524 of
                                                     '}' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'}'" "not match pattern: " "" d480_523 ["char"])
                                                 let '}' = t938_524
                                                 return ()
                                                 lift (lift (return WCComment)),
                                              do m <- list140_145 (foldl1 mplus [do t <- StateT typ
                                                                                    d483_525 <- get
                                                                                    t941_526 <- StateT char
                                                                                    case t941_526 of
                                                                                        '.' -> return ()
                                                                                        _ -> StateT position >>= (throwError . mkParseError "'.'" "not match pattern: " "" d483_525 ["char"])
                                                                                    let '.' = t941_526
                                                                                    return ()
                                                                                    lift (lift (return t))])
                                                 t1 <- StateT typ
                                                 lift (lift (return $ WType m t1)),
                                              do m <- list140_145 (foldl1 mplus [do t <- StateT typ
                                                                                    d487_527 <- get
                                                                                    t945_528 <- StateT char
                                                                                    case t945_528 of
                                                                                        '.' -> return ()
                                                                                        _ -> StateT position >>= (throwError . mkParseError "'.'" "not match pattern: " "" d487_527 ["char"])
                                                                                    let '.' = t945_528
                                                                                    return ()
                                                                                    lift (lift (return t))])
                                                 v1 <- StateT var
                                                 lift (lift (return $ WVar m v1)),
                                              do d489_529 <- get
                                                 t947_530 <- StateT char
                                                 case t947_530 of
                                                     ':' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "':'" "not match pattern: " "" d489_529 ["char"])
                                                 let ':' = t947_530
                                                 return ()
                                                 w <- list140_145 (foldl1 mplus [do d491_531 <- get
                                                                                    t949_532 <- StateT char
                                                                                    let c1507_533 = t949_532
                                                                                    b1398_534 <- return ((`elem` opChars) c1507_533)
                                                                                    unless b1398_534 (StateT position >>= (throwError . mkParseError "(`elem` opChars) c1507_0" "not match: " "" d491_531 ["char"]))
                                                                                    return c1507_533])
                                                 lift (lift (return $ WOpCon $ ':' : w)),
                                              do w <- list1141_435 (foldl1 mplus [do d493_535 <- get
                                                                                     t951_536 <- StateT char
                                                                                     let c1508_537 = t951_536
                                                                                     b1400_538 <- return ((`elem` opChars) c1508_537)
                                                                                     unless b1400_538 (StateT position >>= (throwError . mkParseError "(`elem` opChars) c1508_0" "not match: " "" d493_535 ["char"]))
                                                                                     return c1508_537])
                                                 lift (lift (return $ WOp w)),
                                              do d494_539 <- get
                                                 t952_540 <- StateT char
                                                 case t952_540 of
                                                     '\'' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'\\''" "not match pattern: " "" d494_539 ["char"])
                                                 let '\'' = t952_540
                                                 return ()
                                                 c <- foldl1 mplus [do d496_541 <- get
                                                                       t954_542 <- StateT char
                                                                       let c1509_543 = t954_542
                                                                       b1403_544 <- return ((`notElem` "\\'") c1509_543)
                                                                       unless b1403_544 (StateT position >>= (throwError . mkParseError "(`notElem` \"\\\\'\") c1509_0" "not match: " "" d496_541 ["char"]))
                                                                       return c1509_543]
                                                 d497_545 <- get
                                                 t955_546 <- StateT char
                                                 case t955_546 of
                                                     '\'' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'\\''" "not match pattern: " "" d497_545 ["char"])
                                                 let '\'' = t955_546
                                                 return ()
                                                 lift (lift (return $ WChar c)),
                                              do d498_547 <- get
                                                 t956_548 <- StateT char
                                                 case t956_548 of
                                                     '\'' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'\\''" "not match pattern: " "" d498_547 ["char"])
                                                 let '\'' = t956_548
                                                 return ()
                                                 d499_549 <- get
                                                 t957_550 <- StateT char
                                                 case t957_550 of
                                                     '\\' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'\\\\'" "not match pattern: " "" d499_549 ["char"])
                                                 let '\\' = t957_550
                                                 return ()
                                                 c <- StateT escChar
                                                 d501_551 <- get
                                                 t959_552 <- StateT char
                                                 case t959_552 of
                                                     '\'' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'\\''" "not match pattern: " "" d501_551 ["char"])
                                                 let '\'' = t959_552
                                                 return ()
                                                 lift (lift (return $ WChar c)),
                                              do d502_553 <- get
                                                 t960_554 <- StateT char
                                                 case t960_554 of
                                                     '"' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'\"'" "not match pattern: " "" d502_553 ["char"])
                                                 let '"' = t960_554
                                                 return ()
                                                 s <- StateT strLit
                                                 d504_555 <- get
                                                 t962_556 <- StateT char
                                                 case t962_556 of
                                                     '"' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'\"'" "not match pattern: " "" d504_555 ["char"])
                                                 let '"' = t962_556
                                                 return ()
                                                 lift (lift (return $ WString s)),
                                              do d <- list1141_435 (foldl1 mplus [do d506_557 <- get
                                                                                     t964_558 <- StateT char
                                                                                     let c1510_559 = t964_558
                                                                                     b1413_560 <- return (isDigit c1510_559)
                                                                                     unless b1413_560 (StateT position >>= (throwError . mkParseError "isDigit c1510_0" "not match: " "" d506_557 ["char"]))
                                                                                     return c1510_559])
                                                 lift (lift (return $ WInteger $ read d)),
                                              do b <- StateT bras
                                                 lift (lift (return b)),
                                              do d508_561 <- get
                                                 t966_562 <- StateT char
                                                 case t966_562 of
                                                     ',' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "','" "not match pattern: " "" d508_561 ["char"])
                                                 let ',' = t966_562
                                                 return ()
                                                 lift (lift (return WComma)),
                                              do d509_563 <- get
                                                 t967_564 <- StateT char
                                                 case t967_564 of
                                                     '`' -> return ()
                                                     _ -> StateT position >>= (throwError . mkParseError "'`'" "not match pattern: " "" d509_563 ["char"])
                                                 let '`' = t967_564
                                                 return ()
                                                 lift (lift (return WBackQuote))]
                bras126_130 = foldl1 mplus [do d510_565 <- get
                                               t968_566 <- StateT char
                                               case t968_566 of
                                                   '[' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'['" "not match pattern: " "" d510_565 ["char"])
                                               let '[' = t968_566
                                               return ()
                                               lift (lift (return WOBracket)),
                                            do d511_567 <- get
                                               t969_568 <- StateT char
                                               case t969_568 of
                                                   ']' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "']'" "not match pattern: " "" d511_567 ["char"])
                                               let ']' = t969_568
                                               return ()
                                               lift (lift (return WCBracket)),
                                            do d512_569 <- get
                                               t970_570 <- StateT char
                                               case t970_570 of
                                                   '{' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'{'" "not match pattern: " "" d512_569 ["char"])
                                               let '{' = t970_570
                                               return ()
                                               lift (lift (return WOBrace)),
                                            do d513_571 <- get
                                               t971_572 <- StateT char
                                               case t971_572 of
                                                   '}' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'}'" "not match pattern: " "" d513_571 ["char"])
                                               let '}' = t971_572
                                               return ()
                                               lift (lift (return WCBrace)),
                                            do d514_573 <- get
                                               t972_574 <- StateT char
                                               case t972_574 of
                                                   '(' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "'('" "not match pattern: " "" d514_573 ["char"])
                                               let '(' = t972_574
                                               return ()
                                               lift (lift (return WOParen)),
                                            do d515_575 <- get
                                               t973_576 <- StateT char
                                               case t973_576 of
                                                   ')' -> return ()
                                                   _ -> StateT position >>= (throwError . mkParseError "')'" "not match pattern: " "" d515_575 ["char"])
                                               let ')' = t973_576
                                               return ()
                                               lift (lift (return WCParen))]
                typ127_131 = foldl1 mplus [do u <- foldl1 mplus [do d517_577 <- get
                                                                    t975_578 <- StateT char
                                                                    let c1511_579 = t975_578
                                                                    b1424_580 <- return (isUpper c1511_579)
                                                                    unless b1424_580 (StateT position >>= (throwError . mkParseError "isUpper c1511_0" "not match: " "" d517_577 ["char"]))
                                                                    return c1511_579]
                                              cs <- list140_145 (foldl1 mplus [do d519_581 <- get
                                                                                  t977_582 <- StateT char
                                                                                  let c1512_583 = t977_582
                                                                                  b1426_584 <- return (((||) <$> isAlphaNum <*> (`elem` "_'")) c1512_583)
                                                                                  unless b1426_584 (StateT position >>= (throwError . mkParseError "((||) <$> isAlphaNum <*> (`elem` \"_'\")) c1512_0" "not match: " "" d519_581 ["char"]))
                                                                                  return c1512_583])
                                              lift (lift (return $ u : cs))]
                var128_132 = foldl1 mplus [do l <- foldl1 mplus [do d521_585 <- get
                                                                    t979_586 <- StateT char
                                                                    let c1513_587 = t979_586
                                                                    b1428_588 <- return (((||) <$> isLower <*> (== '_')) c1513_587)
                                                                    unless b1428_588 (StateT position >>= (throwError . mkParseError "((||) <$> isLower <*> (== '_')) c1513_0" "not match: " "" d521_585 ["char"]))
                                                                    return c1513_587]
                                              cs <- list140_145 (foldl1 mplus [do d523_589 <- get
                                                                                  t981_590 <- StateT char
                                                                                  let c1514_591 = t981_590
                                                                                  b1430_592 <- return (((||) <$> isAlphaNum <*> (`elem` "_'")) c1514_591)
                                                                                  unless b1430_592 (StateT position >>= (throwError . mkParseError "((||) <$> isAlphaNum <*> (`elem` \"_'\")) c1514_0" "not match: " "" d523_589 ["char"]))
                                                                                  return c1514_591])
                                              lift (lift (return $ l : cs))]
                strLit129_133 = foldl1 mplus [do c0 <- foldl1 mplus [do d525_593 <- get
                                                                        t983_594 <- StateT char
                                                                        case t983_594 of
                                                                            '\\' -> return ()
                                                                            _ -> StateT position >>= (throwError . mkParseError "'\\\\'" "not match pattern: " "" d525_593 ["char"])
                                                                        let '\\' = t983_594
                                                                        return ()
                                                                        c <- StateT escChar
                                                                        lift (lift (return c)),
                                                                     do d527_595 <- get
                                                                        t985_596 <- StateT char
                                                                        let c1515_597 = t985_596
                                                                        b1434_598 <- return ((`notElem` "\"\\") c1515_597)
                                                                        unless b1434_598 (StateT position >>= (throwError . mkParseError "(`notElem` \"\\\"\\\\\") c1515_0" "not match: " "" d527_595 ["char"]))
                                                                        return c1515_597]
                                                 s <- StateT strLit
                                                 lift (lift (return $ c0 : s)),
                                              lift (lift (return ""))]
                escChar130_134 = foldl1 mplus [do d529_599 <- get
                                                  t987_600 <- StateT char
                                                  case t987_600 of
                                                      '\\' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'\\\\'" "not match pattern: " "" d529_599 ["char"])
                                                  let '\\' = t987_600
                                                  return ()
                                                  lift (lift (return '\\')),
                                               do d530_601 <- get
                                                  t988_602 <- StateT char
                                                  case t988_602 of
                                                      '\'' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'\\''" "not match pattern: " "" d530_601 ["char"])
                                                  let '\'' = t988_602
                                                  return ()
                                                  lift (lift (return '\'')),
                                               do d531_603 <- get
                                                  t989_604 <- StateT char
                                                  case t989_604 of
                                                      '"' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'\"'" "not match pattern: " "" d531_603 ["char"])
                                                  let '"' = t989_604
                                                  return ()
                                                  lift (lift (return '"')),
                                               do d532_605 <- get
                                                  t990_606 <- StateT char
                                                  case t990_606 of
                                                      'n' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'n'" "not match pattern: " "" d532_605 ["char"])
                                                  let 'n' = t990_606
                                                  return ()
                                                  lift (lift (return '\n')),
                                               do d533_607 <- get
                                                  t991_608 <- StateT char
                                                  case t991_608 of
                                                      'r' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'r'" "not match pattern: " "" d533_607 ["char"])
                                                  let 'r' = t991_608
                                                  return ()
                                                  lift (lift (return '\r')),
                                               do d534_609 <- get
                                                  t992_610 <- StateT char
                                                  case t992_610 of
                                                      't' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'t'" "not match pattern: " "" d534_609 ["char"])
                                                  let 't' = t992_610
                                                  return ()
                                                  lift (lift (return '\t')),
                                               do d535_611 <- get
                                                  t993_612 <- StateT char
                                                  case t993_612 of
                                                      'x' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'x'" "not match pattern: " "" d535_611 ["char"])
                                                  let 'x' = t993_612
                                                  return ()
                                                  ds <- list1141_435 (foldl1 mplus [do d537_613 <- get
                                                                                       t995_614 <- StateT char
                                                                                       let c1516_615 = t995_614
                                                                                       b1444_616 <- return (isHexDigit c1516_615)
                                                                                       unless b1444_616 (StateT position >>= (throwError . mkParseError "isHexDigit c1516_0" "not match: " "" d537_613 ["char"]))
                                                                                       return c1516_615])
                                                  lift (lift (return $ chr $ fst $ head $ readHex ds))]
                space131_135 = foldl1 mplus [do _ <- foldl1 mplus [do d539_617 <- get
                                                                      t997_618 <- StateT char
                                                                      let c1517_619 = t997_618
                                                                      b1446_620 <- return ((`elem` " \t") c1517_619)
                                                                      unless b1446_620 (StateT position >>= (throwError . mkParseError "(`elem` \" \\t\") c1517_0" "not match: " "" d539_617 ["char"]))
                                                                      return c1517_619]
                                                return ()
                                                return (),
                                             do _ <- StateT notSemiColon
                                                return ()
                                                return (),
                                             do _ <- StateT comment
                                                return ()
                                                return (),
                                             do _ <- StateT lineComment
                                                return ()
                                                return ()]
                space'132_136 = foldl1 mplus [do _ <- foldl1 mplus [do d544_621 <- get
                                                                       t1002_622 <- StateT char
                                                                       let c1518_623 = t1002_622
                                                                       b1451_624 <- return ((`elem` " \t") c1518_623)
                                                                       unless b1451_624 (StateT position >>= (throwError . mkParseError "(`elem` \" \\t\") c1518_0" "not match: " "" d544_621 ["char"]))
                                                                       return c1518_623]
                                                 return ()
                                                 return (),
                                              do _ <- list1141_435 (foldl1 mplus [do d546_625 <- get
                                                                                     t1004_626 <- StateT char
                                                                                     case t1004_626 of
                                                                                         '\n' -> return ()
                                                                                         _ -> StateT position >>= (throwError . mkParseError "'\\n'" "not match pattern: " "" d546_625 ["char"])
                                                                                     let '\n' = t1004_626
                                                                                     return ()
                                                                                     lift (lift (return ()))])
                                                 return ()
                                                 return (),
                                              do _ <- StateT comment
                                                 return ()
                                                 return (),
                                              do _ <- StateT lineComment
                                                 return ()
                                                 return ()]
                lineComment133_137 = foldl1 mplus [do d549_627 <- get
                                                      t1007_628 <- StateT char
                                                      case t1007_628 of
                                                          '-' -> return ()
                                                          _ -> StateT position >>= (throwError . mkParseError "'-'" "not match pattern: " "" d549_627 ["char"])
                                                      let '-' = t1007_628
                                                      return ()
                                                      d550_629 <- get
                                                      t1008_630 <- StateT char
                                                      case t1008_630 of
                                                          '-' -> return ()
                                                          _ -> StateT position >>= (throwError . mkParseError "'-'" "not match pattern: " "" d550_629 ["char"])
                                                      let '-' = t1008_630
                                                      return ()
                                                      _ <- list140_145 (foldl1 mplus [do d552_631 <- get
                                                                                         t1010_632 <- StateT char
                                                                                         let c1519_633 = t1010_632
                                                                                         b1459_634 <- return ((/= '\n') c1519_633)
                                                                                         unless b1459_634 (StateT position >>= (throwError . mkParseError "(/= '\\n') c1519_0" "not match: " "" d552_631 ["char"]))
                                                                                         return c1519_633])
                                                      return ()
                                                      d554_635 <- get
                                                      _ <- do d553_636 <- get
                                                              t1011_637 <- StateT char
                                                              case t1011_637 of
                                                                  '\n' -> return ()
                                                                  _ -> StateT position >>= (throwError . mkParseError "'\\n'" "not match pattern: " "" d553_636 ["char"])
                                                              let '\n' = t1011_637
                                                              return ()
                                                      put d554_635
                                                      return ()]
                comment134_138 = foldl1 mplus [do d555_638 <- get
                                                  t1012_639 <- StateT char
                                                  case t1012_639 of
                                                      '{' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'{'" "not match pattern: " "" d555_638 ["char"])
                                                  let '{' = t1012_639
                                                  return ()
                                                  d556_640 <- get
                                                  t1013_641 <- StateT char
                                                  case t1013_641 of
                                                      '-' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'-'" "not match pattern: " "" d556_640 ["char"])
                                                  let '-' = t1013_641
                                                  return ()
                                                  d558_642 <- get
                                                  do err1499_643 <- ((do d557_644 <- get
                                                                         t1014_645 <- StateT char
                                                                         case t1014_645 of
                                                                             '#' -> return ()
                                                                             _ -> StateT position >>= (throwError . mkParseError "'#'" "not match pattern: " "" d557_644 ["char"])
                                                                         let '#' = t1014_645
                                                                         return ()) >> return False) `catchError` const (return True)
                                                     unless err1499_643 (StateT position >>= (throwError . mkParseError "!'#':" "not match: " "" d558_642 ["char"]))
                                                  put d558_642
                                                  _ <- StateT comments
                                                  return ()
                                                  d560_646 <- get
                                                  t1016_647 <- StateT char
                                                  case t1016_647 of
                                                      '-' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'-'" "not match pattern: " "" d560_646 ["char"])
                                                  let '-' = t1016_647
                                                  return ()
                                                  d561_648 <- get
                                                  t1017_649 <- StateT char
                                                  case t1017_649 of
                                                      '}' -> return ()
                                                      _ -> StateT position >>= (throwError . mkParseError "'}'" "not match pattern: " "" d561_648 ["char"])
                                                  let '}' = t1017_649
                                                  return ()
                                                  return ()]
                comments135_139 = foldl1 mplus [do _ <- StateT comStr
                                                   return ()
                                                   _ <- StateT comment
                                                   return ()
                                                   _ <- StateT comments
                                                   return ()
                                                   return (),
                                                do _ <- StateT comStr
                                                   return ()
                                                   return ()]
                comStr136_140 = foldl1 mplus [do d567_650 <- get
                                                 do err1500_651 <- ((do _ <- StateT comment
                                                                        return ()) >> return False) `catchError` const (return True)
                                                    unless err1500_651 (StateT position >>= (throwError . mkParseError "!_:comment" "not match: " "" d567_650 ["comment"]))
                                                 put d567_650
                                                 d571_652 <- get
                                                 do err1501_653 <- ((do _ <- foldl1 mplus [do d569_654 <- get
                                                                                              t1024_655 <- StateT char
                                                                                              case t1024_655 of
                                                                                                  '-' -> return ()
                                                                                                  _ -> StateT position >>= (throwError . mkParseError "'-'" "not match pattern: " "" d569_654 ["char"])
                                                                                              let '-' = t1024_655
                                                                                              return ()
                                                                                              d570_656 <- get
                                                                                              t1025_657 <- StateT char
                                                                                              case t1025_657 of
                                                                                                  '}' -> return ()
                                                                                                  _ -> StateT position >>= (throwError . mkParseError "'}'" "not match pattern: " "" d570_656 ["char"])
                                                                                              let '}' = t1025_657
                                                                                              return ()
                                                                                              return ()]
                                                                        return ()) >> return False) `catchError` const (return True)
                                                    unless err1501_653 (StateT position >>= (throwError . mkParseError "!_:('-': '}': {})" "not match: " "" d571_652 ["char"]))
                                                 put d571_652
                                                 _ <- StateT char
                                                 return ()
                                                 _ <- StateT comStr
                                                 return ()
                                                 return (),
                                              return ()]
                semiColon137_141 = foldl1 mplus [do d574_658 <- get
                                                    t1028_659 <- StateT char
                                                    case t1028_659 of
                                                        ';' -> return ()
                                                        _ -> StateT position >>= (throwError . mkParseError "';'" "not match pattern: " "" d574_658 ["char"])
                                                    let ';' = t1028_659
                                                    return ()
                                                    return (),
                                                 do _ <- list1141_435 (foldl1 mplus [do d576_660 <- get
                                                                                        t1030_661 <- StateT char
                                                                                        case t1030_661 of
                                                                                            '\n' -> return ()
                                                                                            _ -> StateT position >>= (throwError . mkParseError "'\\n'" "not match pattern: " "" d576_660 ["char"])
                                                                                        let '\n' = t1030_661
                                                                                        return ()
                                                                                        lift (lift (return ()))])
                                                    return ()
                                                    _ <- list140_145 (foldl1 mplus [do d578_662 <- get
                                                                                       t1032_663 <- StateT char
                                                                                       case t1032_663 of
                                                                                           '\t' -> return ()
                                                                                           _ -> StateT position >>= (throwError . mkParseError "'\\t'" "not match pattern: " "" d578_662 ["char"])
                                                                                       let '\t' = t1032_663
                                                                                       return ()
                                                                                       return (),
                                                                                    do d579_664 <- get
                                                                                       t1033_665 <- StateT char
                                                                                       case t1033_665 of
                                                                                           ' ' -> return ()
                                                                                           _ -> StateT position >>= (throwError . mkParseError "' '" "not match pattern: " "" d579_664 ["char"])
                                                                                       let ' ' = t1033_665
                                                                                       return ()
                                                                                       return ()])
                                                    return ()
                                                    d580_666 <- get
                                                    t1034_667 <- StateT position
                                                    let (!(ListPos (CharPos (_, x)))) = t1034_667
                                                    b1483_668 <- lift (lift (maybe False (x <=) <$> get))
                                                    unless b1483_668 (StateT position >>= (throwError . mkParseError "maybe False (x <=) <$> get" "not match: " "" d580_666 ["position"]))
                                                    d582_669 <- get
                                                    do err1502_670 <- ((do _ <- StateT lineComment
                                                                           return ()) >> return False) `catchError` const (return True)
                                                       unless err1502_670 (StateT position >>= (throwError . mkParseError "!_:lineComment" "not match: " "" d582_669 ["lineComment"]))
                                                    put d582_669
                                                    d584_671 <- get
                                                    do err1503_672 <- ((do _ <- StateT comment
                                                                           return ()) >> return False) `catchError` const (return True)
                                                       unless err1503_672 (StateT position >>= (throwError . mkParseError "!_:comment" "not match: " "" d584_671 ["comment"]))
                                                    put d584_671
                                                    d586_673 <- get
                                                    do err1504_674 <- ((do d585_675 <- get
                                                                           t1037_676 <- StateT char
                                                                           case t1037_676 of
                                                                               ';' -> return ()
                                                                               _ -> StateT position >>= (throwError . mkParseError "';'" "not match pattern: " "" d585_675 ["char"])
                                                                           let ';' = t1037_676
                                                                           return ()) >> return False) `catchError` const (return True)
                                                       unless err1504_674 (StateT position >>= (throwError . mkParseError "!';':" "not match: " "" d586_673 ["char"]))
                                                    put d586_673
                                                    return (),
                                                 do d588_677 <- get
                                                    do err1505_678 <- ((do d587_679 <- get
                                                                           _ <- StateT char
                                                                           b1487_680 <- lift (lift (return True))
                                                                           unless b1487_680 (StateT position >>= (throwError . mkParseError "return True" "not match: " "" d587_679 ["char"]))) >> return False) `catchError` const (return True)
                                                       unless err1505_678 (StateT position >>= (throwError . mkParseError "!_:[return True]" "not match: " "" d588_677 ["char"]))
                                                    put d588_677
                                                    return ()]
                notSemiColon138_142 = foldl1 mplus [do _ <- list1141_435 (foldl1 mplus [do d590_681 <- get
                                                                                           t1040_682 <- StateT char
                                                                                           case t1040_682 of
                                                                                               '\n' -> return ()
                                                                                               _ -> StateT position >>= (throwError . mkParseError "'\\n'" "not match pattern: " "" d590_681 ["char"])
                                                                                           let '\n' = t1040_682
                                                                                           return ()
                                                                                           lift (lift (return ()))])
                                                       return ()
                                                       _ <- list140_145 (foldl1 mplus [do d592_683 <- get
                                                                                          t1042_684 <- StateT char
                                                                                          case t1042_684 of
                                                                                              '\t' -> return ()
                                                                                              _ -> StateT position >>= (throwError . mkParseError "'\\t'" "not match pattern: " "" d592_683 ["char"])
                                                                                          let '\t' = t1042_684
                                                                                          return ()
                                                                                          return (),
                                                                                       do d593_685 <- get
                                                                                          t1043_686 <- StateT char
                                                                                          case t1043_686 of
                                                                                              ' ' -> return ()
                                                                                              _ -> StateT position >>= (throwError . mkParseError "' '" "not match pattern: " "" d593_685 ["char"])
                                                                                          let ' ' = t1043_686
                                                                                          return ()
                                                                                          return ()])
                                                       return ()
                                                       d594_687 <- get
                                                       t1044_688 <- StateT position
                                                       let (!(ListPos (CharPos (_, x)))) = t1044_688
                                                       b1493_689 <- lift (lift (maybe True (x >) <$> get))
                                                       unless b1493_689 (StateT position >>= (throwError . mkParseError "maybe True (x >) <$> get" "not match: " "" d594_687 ["position"]))
                                                       return (),
                                                    do _ <- list1141_435 (foldl1 mplus [do d596_690 <- get
                                                                                           t1046_691 <- StateT char
                                                                                           case t1046_691 of
                                                                                               '\n' -> return ()
                                                                                               _ -> StateT position >>= (throwError . mkParseError "'\\n'" "not match pattern: " "" d596_690 ["char"])
                                                                                           let '\n' = t1046_691
                                                                                           return ()
                                                                                           lift (lift (return ()))])
                                                       return ()
                                                       _ <- StateT lineComment
                                                       return ()
                                                       return (),
                                                    do _ <- list1141_435 (foldl1 mplus [do d599_692 <- get
                                                                                           t1049_693 <- StateT char
                                                                                           case t1049_693 of
                                                                                               '\n' -> return ()
                                                                                               _ -> StateT position >>= (throwError . mkParseError "'\\n'" "not match pattern: " "" d599_692 ["char"])
                                                                                           let '\n' = t1049_693
                                                                                           return ()
                                                                                           lift (lift (return ()))])
                                                       return ()
                                                       _ <- StateT comment
                                                       return ()
                                                       return (),
                                                    do _ <- list1141_435 (foldl1 mplus [do d602_694 <- get
                                                                                           t1052_695 <- StateT char
                                                                                           case t1052_695 of
                                                                                               '\n' -> return ()
                                                                                               _ -> StateT position >>= (throwError . mkParseError "'\\n'" "not match pattern: " "" d602_694 ["char"])
                                                                                           let '\n' = t1052_695
                                                                                           return ()
                                                                                           lift (lift (return ()))])
                                                       return ()
                                                       d604_696 <- get
                                                       _ <- do d603_697 <- get
                                                               t1053_698 <- StateT char
                                                               case t1053_698 of
                                                                   ';' -> return ()
                                                                   _ -> StateT position >>= (throwError . mkParseError "';'" "not match pattern: " "" d603_697 ["char"])
                                                               let ';' = t1053_698
                                                               return ()
                                                       put d604_696
                                                       return ()]
                list140_145 :: forall m a . (MonadPlus m, Applicative m) =>
                                            m a -> m ([a])
                list1141_435 :: forall m a . (MonadPlus m, Applicative m) =>
                                             m a -> m ([a])
                list140_145 p = list1141_435 p `mplus` return []
                list1141_435 p = ((:) <$> p) <*> list140_145 p
                optional139_204 :: forall m a . (MonadPlus m, Applicative m) =>
                                                m a -> m (Maybe a)
                optional139_204 p = (Just <$> p) `mplus` return Nothing


