var path = require('path')
var webpack = require('webpack')

module.exports = {
  entry: {
    linden: './src/index.js',
  },

  output: {
    filename: '[name].js',
    path: path.join(__dirname, 'build'),
  },

  module: {
    loaders: [
      {
        test: /\.js$/,
        exclude: /node_modules/,
        loader: 'babel',
      },
      {
        test: /\.less$/,
        loaders: ['style', 'css', 'autoprefixer', 'less'],
      },
      {
        test: /\.png$|\.gif$/,
        loader: 'url',
      },
    ],
  },

  plugins: [
    new webpack.BannerPlugin('linden by chromako.de'),
  ],
}
