require('core-js/fn/object/assign')
require('core-js/fn/array/map')
require('core-js/fn/array/find-index')
require('core-js/fn/array/filter')
require('core-js/fn/date/now')
require('core-js/es6/promise')
require('whatwg-fetch')

require('./index.less')
var GardenClient = require('./GardenClient')

var scripts = document.getElementsByTagName('script')
var script = scripts[scripts.length - 1]

window.garden = new GardenClient({
  name: 'garden',
  el: document.getElementById('comic'),
  width: 740,
  height: 462,
  title: script.getAttribute('data-title'),
  endpoint: script.getAttribute('data-endpoint'),
  imgPrefix: script.getAttribute('data-image-endpoint'),
  spread: {
    reload: 60,
  },
  debug: location.search === '?debug',
}).run()

window.addEventListener('keydown', function preventBackNav(ev) {
  // prevent backspace from navigating
  if (ev.which === 8) {
    ev.preventDefault()
  }
}, false)
