function ImgCache() {
  this.imgs = {}
  this.callbacks = {}
}
ImgCache.prototype = {
  get: function get(src, callback) {
    var img = this.imgs[src]

    if (img === undefined) {
      this.imgs[src] = true
      this.callbacks[src] = [callback]
      img = new Image()
      img.onload = this._onDone.bind(this, src, img, img)
      img.onerror = this._onDone.bind(this, src, img, false)
      img.crossOrigin = 'anonymous'
      img.src = src
    } else if (img === true) {
      // loading
      this.callbacks[src].push(callback)
    } else {
      // release zalgo
      if (callback) {
        callback(src, img)
      }
    }
  },

  _onDone: function _onDone(src, img, result) {
    this.imgs[src] = result
    for (var i = 0; i < this.callbacks[src].length; i++) {
      var callback = this.callbacks[src][i]
      if (callback) {
        callback(src, result)
      }
    }
    delete this.callbacks[src]
  },

  getAll: function getAll(srcs, callback) {
    if (!srcs.length) {
      callback([])
      return
    }

    var remaining = srcs.length
    var results = {}

    function loaded(src, img) {
      results[src] = img
      remaining--
      if (remaining === 0) {
        callback(results)
      }
    }

    for (var i = 0; i < srcs.length; i++) {
      this.get(srcs[i], loaded)
    }
  },
}

module.exports = ImgCache
