{-
  Copyright © 2023 Josep Bigorra

  This file is part of Keuringsdienst.
  Keuringsdienst is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation,
    either version 3 of the License, or (at your option) any later version.

  Keuringsdienst is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  See the GNU General Public License for more details.
  You should have received a copy of the GNU General Public License along with Keuringsdienst.
  If not, see <https://www.gnu.org/licenses/>.
-}
{-# OPTIONS_GHC -F -pgmF htfpp #-}

module Keuringsdienst.HelpersSpec
  ( htf_thisModulesTests,
  )
where

import Data.Text as T
import Keuringsdienst as K
import Keuringsdienst.Helpers as KH
import Test.Framework

-- λ test helpers
someText :: Text
someText = "Keuringsdienst van Waarde"

-- λ test cases
-- isEqualTo
test_isEqualToRuleWillSucceedWithText :: IO ()
test_isEqualToRuleWillSucceedWithText =
  assertEqual K.Success systemUnderTest
  where
    systemUnderTest :: ValidationResult
    systemUnderTest = someText |?| isEqualTo someText

test_isEqualToRuleWillFailWithText :: IO ()
test_isEqualToRuleWillFailWithText =
  case systemUnderTest of
    K.Failure _ -> pure ()
    K.Success -> error "Expected rule validation to return a failure"
  where
    systemUnderTest :: ValidationResult
    systemUnderTest = T.take 1 someText |?| isEqualTo someText

-- isNotEqualTo
test_isNotEqualToRuleWillSucceedWithText :: IO ()
test_isNotEqualToRuleWillSucceedWithText =
  assertEqual K.Success systemUnderTest
  where
    systemUnderTest :: ValidationResult
    systemUnderTest = T.take 1 someText |?| isNotEqualTo someText

test_isNotEqualToRuleWillFailWithText :: IO ()
test_isNotEqualToRuleWillFailWithText =
  case systemUnderTest of
    K.Failure _ -> pure ()
    K.Success -> error "Expected rule validation to return a failure"
  where
    systemUnderTest :: ValidationResult
    systemUnderTest = someText |?| isNotEqualTo someText
