module Control.Effect.Carrier
  ( -- * Core types
    Carrier(..)

  , Algebra
  , Algebra'

  , Reformulation
  , Reformulation'

    -- * Combinators for 'Algebra's
  , powerAlg
  , powerAlg'
  , weakenAlg
  , coerceAlg

   -- * Combinators for 'Reformulation's
  , liftReform
  , addDeriv
  , addPrim
  , weakenReform
  , weakenReformUnder1
  , weakenReformUnder
  , weakenReformUnderMany
  , coerceReform

    -- * Hiding effects
  , StripPrefix

    -- * Type Coercion
  , module Data.Coerce

    -- * Common classes for newtype deriving
  , module Control.Effect.Internal.Derive

    -- * Primitive effects
  , module Control.Effect.Primitive

    -- * Union
  , module Control.Effect.Union
  ) where

import Data.Coerce
import Control.Effect
import Control.Effect.Internal
import Control.Effect.Primitive
import Control.Effect.Union
import Control.Effect.Internal.Derive
import Control.Effect.Internal.KnownList
import Control.Effect.Internal.Union
import Control.Effect.Carrier.Internal.Interpret
