{
{-# OPTIONS_GHC -w #-}
{-
Copyright (C) HyLoRes 2002-2007. See AUTHORS file

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
USA.
-}

module HyLo.InputFile.OldParser ( parse )

where

import HyLo.InputFile.OldLexer ( Token(..), FilePos, line, col )

import HyLo.Signature.Simple ( PropSymbol(..),
                               NomSymbol(..),
                               RelSymbol(..) )

-- since ghc 6.10, "Down" is defined in GHC.Exts, that is included
-- (unqualified) in the parser. we need to use Formula.Down instead of
-- simply Down to avoid ambiguities...
import HyLo.Formula as Formula ( Formula(..) )
}

%name parse
%tokentype { (Token, FilePos) }

%token
             begin           { (TokenBegin    , _) }
             end             { (TokenEnd      , _) }
             at              { (TokenAt       , _) }
             at2             { (TokenAt2      , _) }
             down            { (TokenDown     , _) }
             prop            { (TokenProp $$  , _) }
             nom             { (TokenNom $$   , _) }
             var             { (TokenVar $$   , _) }
             true            { (TokenTrue     , _) }
             false           { (TokenFalse    , _) }
             neg             { (TokenNeg      , _) }
             and             { (TokenAnd      , _) }
             or              { (TokenOr       , _) }
             dimp            { (TokenDimp     , _) }
             imp             { (TokenImp      , _) }
             box             { (TokenBox $$   , _) }
             ibox            { (TokenIBox $$  , _) }
             ubox            { (TokenUBox     , _) }
             dbox            { (TokenDBox     , _) }
             dia             { (TokenDia $$   , _) }
             idia            { (TokenIDia $$  , _) }
             udia            { (TokenUDia     , _) }
             ddia            { (TokenDDia     , _) }
             '('             { (TokenOB       , _) }
             ')'             { (TokenCB       , _) }
             ';'             { (TokenSC       , _) }
             '.'             { (TokenDot      , _) }
%right imp
%right dimp
%left or
%left and
%left box ibox ubox dbox dia idia udia ddia neg
%right down
%right at

%%

Input :: { [Formula NomSymbol PropSymbol RelSymbol] }
Input :
  begin Formulas end               { $2 }

Formulas :: { [Formula NomSymbol PropSymbol RelSymbol] }
Formulas :
  Formula                          { [$1] }
| Formula ';' Formulas             { $1:$3 }


Formula :: { Formula NomSymbol PropSymbol RelSymbol }
Formula :
  true                             { Top          }
| false                            { Bot          }
| var                              { Nom $1      }
| nom                              { Nom  $1      }
| prop                             { Prop $1      }
| dia    Formula                   { Diam $1 $2   }
| idia    Formula                  { IDiam $1 $2  }
| udia   Formula                   { E $2         }
| ddia   Formula                   { D $2         }
| box    Formula                   { Box $1 $2    }
| ibox    Formula                  { IBox $1 $2   }
| ubox Formula                     { A $2         }
| dbox   Formula                   { B $2         }
| Formula dimp Formula             { $1 :<-->: $3 }
| Formula imp Formula              { $1 :-->: $3  }
| neg Formula                      { Neg $2       }
| Formula and Formula              { $1 :&: $3    }
| Formula or Formula               { $1 :|: $3    }
| nom at Formula                   { At  $1 $3   }
| at2 nom Formula %prec at         { At  $2 $3   }
| var at Formula                   { At  $1 $3   }
| at2 var Formula %prec at         { At  $2 $3   }
| down '(' var  Formula ')'        { Formula.Down $3 $4   }
| down var '.' Formula %prec down  { Formula.Down $2 $4   }
| '(' Formula ')'                  { $2           }

{
happyError :: [(Token, FilePos)] -> a
happyError ((_, fp):_) = error ("Parse error near line " ++
                                   (show $ line fp) ++
                                   ", col. " ++
                                   (show $ col fp))
}
