{-# LANGUAGE DeriveGeneric #-}
{-# LANGUAGE StrictData    #-}
module Language.Cimple.Tokens
    ( LexemeClass (..)
    ) where

import           Data.Aeson      (FromJSON, ToJSON)
import           Data.Hashable   (Hashable)
import           GHC.Generics    (Generic)
import           Test.QuickCheck (Arbitrary (..), arbitraryBoundedEnum,
                                  suchThat)

data LexemeClass
    = IdConst
    | IdFuncType
    | IdStdType
    | IdSueType
    | IdVar
    | KwBitwise
    | KwBreak
    | KwCase
    | KwConst
    | KwContinue
    | KwDefault
    | KwDo
    | KwElse
    | KwEnum
    | KwExtern
    | KwFor
    | KwForce
    | KwGnuPrintf
    | KwGoto
    | KwIf
    | KwNonnull
    | KwNullable
    | KwOwner
    | KwReturn
    | KwSizeof
    | KwStatic
    | KwStaticAssert
    | KwStruct
    | KwSwitch
    | KwTypedef
    | KwUnion
    | KwVla
    | KwVoid
    | KwWhile
    | LitFalse
    | LitTrue
    | LitChar
    | LitFloat
    | LitInteger
    | LitString
    | LitSysInclude
    | PctAmpersand
    | PctAmpersandAmpersand
    | PctAmpersandEq
    | PctArrow
    | PctAsterisk
    | PctAsteriskEq
    | PctCaret
    | PctCaretEq
    | PctColon
    | PctComma
    | PctEllipsis
    | PctEMark
    | PctEMarkEq
    | PctEq
    | PctEqEq
    | PctGreater
    | PctGreaterEq
    | PctGreaterGreater
    | PctGreaterGreaterEq
    | PctLBrace
    | PctLBrack
    | PctLess
    | PctLessEq
    | PctLessLess
    | PctLessLessEq
    | PctLParen
    | PctMinus
    | PctMinusEq
    | PctMinusMinus
    | PctPeriod
    | PctPercent
    | PctPercentEq
    | PctPipe
    | PctPipeEq
    | PctPipePipe
    | PctPlus
    | PctPlusEq
    | PctPlusPlus
    | PctQMark
    | PctRBrace
    | PctRBrack
    | PctRParen
    | PctSemicolon
    | PctSlash
    | PctSlashEq
    | PctTilde
    | PpDefine
    | PpDefined
    | PpElif
    | PpElse
    | PpEndif
    | PpIf
    | PpIfdef
    | PpIfndef
    | PpInclude
    | PpNewline
    | PpUndef
    | CmtBlock
    | CmtCommand
    | CmtAttr
    | CmtEndDocSection
    | CmtSpace
    | CmtStart
    | CmtStartCode
    | CmtStartBlock
    | CmtStartDoc
    | CmtStartDocSection
    | CmtSpdxCopyright
    | CmtSpdxLicense
    | CmtCode
    | CmtWord
    | CmtRef
    | CmtEnd
    | IgnStart
    | IgnBody
    | IgnEnd

    | ErrorToken
    | Eof
    deriving (Enum, Bounded, Ord, Eq, Show, Read, Generic)

instance FromJSON LexemeClass
instance ToJSON LexemeClass
instance Hashable LexemeClass

instance Arbitrary LexemeClass where
    arbitrary = arbitraryBoundedEnum `suchThat` ok
      where
        ok ErrorToken = False
        ok Eof        = False
        ok _          = True
