module Bio.Util.Nub ( nubHash, nubHashBy )where

import BasePrelude
import Data.Hashable ( Hashable )
import qualified Data.HashSet as H

nubHash :: (Hashable a, Eq a) => [a] -> [a]
nubHash = nubHashBy id

nubHashBy :: (Hashable b, Eq b) => (a -> b) -> [a] -> [a]
nubHashBy f = go H.empty
  where
    go _ [] = []
    go h (x:xs) | f x `H.member` h = go h xs
                | otherwise        = x : go (H.insert (f x) h) xs

