{-# LANGUAGE CPP #-}
module Bio.Prelude (
    module BasePrelude,
    module Bio.Base,
    module Bio.Util.Text,
    module Control.Monad.Catch,
    module Control.Monad.IO.Class,
    module Control.Monad.Trans.Class,
    module Data.Bifunctor,
    module Data.List.NonEmpty,
    module Data.Semigroup,
    module System.IO,

    Bytes, LazyBytes,
    Generic1(..),
    Hashable(..),
    Hashable1(..),
    Hashable2(..),
    HashMap,
    HashSet,
    IntMap,
    IntSet,
    NonEmpty(..),
    Semigroup(..),
    Text, LazyText
                   ) where

import BasePrelude hiding ( (<>), EOF
                          , bracket, bracket_, bracketOnError
                          , catch, catches, catchIOError, catchJust
                          , Handler, handle, handleJust
                          , finally, try, tryJust, onException
                          , mask, mask_, uninterruptibleMask, uninterruptibleMask_
#if MIN_VERSION_base(4,9,0)
                          , log1p, log1pexp, log1mexp, expm1
#endif
                          )

import Bio.Base
import Bio.Util.Text
import Control.Monad.Catch
import Control.Monad.IO.Class
import Control.Monad.Trans.Class
import Data.Bifunctor
import Data.ByteString              ( ByteString )
import Data.List.NonEmpty           ( NonEmpty(..) )
import Data.Semigroup               ( Semigroup(..) )
import Data.Text                    ( Text )
import Data.Hashable                ( Hashable(..) )
import Data.Hashable.Lifted         ( Hashable1(..), Hashable2(..) )
import Data.HashMap.Strict          ( HashMap )
import Data.HashSet                 ( HashSet )
import Data.IntMap                  ( IntMap )
import Data.IntSet                  ( IntSet )
import GHC.Generics                 ( Generic1(..) )
import System.IO                    ( hPrint, hPutStr, hPutStrLn, stderr, stdout, stdin
                                    , openBinaryFile, withBinaryFile, IOMode(..)
                                    , hFlush, hSeek, hClose, SeekMode(..) )

import qualified Data.ByteString.Lazy   as BL
import qualified Data.Text.Lazy         as TL

type Bytes     =    ByteString
type LazyBytes = BL.ByteString
type LazyText  = TL.Text
