module System.Apotiki.Templates where
import Data.List (unlines)

--
-- I am NOT proud of this heredoc implementation.
--

detailsHtml = unlines [ "<div class=\"panel panel-default\">",
                        "  <div class=\"panel-heading\">",
                        "    Package: {{repo[arch][name]['Package']}}",
                        "  </div>",
                        "  <div class=\"panel-body\">",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Package</strong></div>",
                        "      <div class=\"col-md-10\">{{repo[arch][name]['Package']}}</div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Version</strong></div>",
                        "      <div class=\"col-md-10\">{{repo[arch][name]['Version']}}</div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Architecture</strong></div>",
                        "      <div class=\"col-md-10\">{{repo[arch][name]['Architecture']}}</div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Maintainer</strong></div>",
                        "      <div class=\"col-md-10\">{{repo[arch][name]['Maintainer']}}</div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>License</strong></div>",
                        "      <div class=\"col-md-10\">{{repo[arch][name]['License']}}</div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Installed Size</strong></div>",
                        "      <div class=\"col-md-10\">{{repo[arch][name]['Installed-Size']}}</div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Priority</strong></div>",
                        "      <div class=\"col-md-10\">{{repo[arch][name]['Priority']}}</div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Depends</strong></div>",
                        "      <div class=\"col-md-10\">{{repo[arch][name]['Depends']}}</div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Homepage</strong></div>",
                        "      <div class=\"col-md-10\"><a href=\"{{repo[arch][name]['Homepage']}}\">{{repo[arch][name]['Homepage']}}</a></div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Vendor</strong></div>",
                        "      <div class=\"col-md-10\">{{repo[arch][name]['Vendor']}}</div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Section</strong></div>",
                        "      <div class=\"col-md-10\">{{repo[arch][name]['Section']}}</div>",
                        "    </div>",
                        "    <div class=\"row\">",
                        "      <div class=\"col-md-2\"><strong>Description</strong></div>",
                        "      <div class=\"col-md-10\">",
                        "        <pre ng-bind=\"repo[arch][name]['Description']\"></pre>",
                        "      </div>",
                        "    </div>",
                        "  </div>",
                        "</div>" ]

indexHtml = unlines [ "<!doctype html>",
                      "<html lang=\"en\">",
                      "",
                      "  <head>",
                      "    <title>apotiki debian repository</title>",
                      "    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">",
                      "    <link href=\"//netdna.bootstrapcdn.com/bootstrap/3.0.3/css/bootstrap.min.css\" rel=\"stylesheet\">",
                      "    <script src=\"//ajax.googleapis.com/ajax/libs/angularjs/1.2.8/angular.min.js\"></script>",
                      "    <script src=\"//ajax.googleapis.com/ajax/libs/angularjs/1.2.8/angular-route.js\"></script>",
                      "    <script src=\"/apotiki.js\"></script>",
                      "  </head>",
                      "",
                      "  <body ng-app=\"repo\">",
                      "    <div class=\"navbar navbar-default\" role=\"navigation\">",
                      "      <div class=\"container\">",
                      "        <div class=\"navbar-header\">",
                      "          <a class=\"navbar-brand\" href=\"#\">apotiki</a>",
                      "        </div>",
                      "        <div class=\"navbar-collapse collapse\">",
                      "          <ul class=\"nav navbar-nav\">",
                      "            <li><a href=\"#list\">Listing</a></li>",
                      "            <li><a href=\"/post.html\">Submit</a></li>",
                      "          </ul>",
                      "        </div>",
                      "      </div>",
                      "    </div>",
                      "      ",
                      "    <div class=\"container\">",
                      "      <div class=\"row\">",
                      "        <div class=\"col-lg-8 col-lg-offset-2\">",
                      "          <ng-view></ng-view>",
                      "        </div>",
                      "      </div>",
                      "    </div>",
                      "    ",
                      "  </body>",
                      "  ",
                      "</html>" ]

postHtml = unlines [ "<!doctype html>",
                     "<html lang=\"en\">",
                     "  <head>",
                     "    <title>apotiki debian repository</title>",
                     "    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">",
                     "    <link href=\"//netdna.bootstrapcdn.com/bootstrap/3.0.3/css/bootstrap.min.css\" rel=\"stylesheet\">",
                     "  </head>",
                     "  <body ng-app=\"repo\">",
                     "    <div class=\"navbar navbar-default\" role=\"navigation\">",
                     "      <div class=\"container\">",
                     "        <div class=\"navbar-header\">",
                     "          <a class=\"navbar-brand\" href=\"#\">apotiki</a>",
                     "        </div>",
                     "        <div class=\"navbar-collapse collapse\">",
                     "          <ul class=\"nav navbar-nav\">",
                     "            <li><a href=\"/index.html#list\">Listing</a></li>",
                     "            <li><a href=\"/post.html\">Submit</a></li>",
                     "          </ul>",
                     "        </div>",
                     "      </div>",
                     "    </div>",
                     "    <div class=\"container\">",
                     "      <div class=\"row\">",
                     "        <div class=\"col-lg-8 col-lg-offset-2\">",
                     "<div class=\"panel panel-default\">",
                     "  <div class=\"panel-heading\">",
                     "    <h4>Package</h4>",
                     "  </div>",
                     "  <div class=\"panel-body\">",
                     "    <form method=\"POST\" action=\"/repo\" enctype=\"multipart/form-data\" role=\"form\">",
                     "      <div class=\"form-group\">",
                     "        <label>Choose package</label>",
                     "        <input type=\"file\" name=\"file\" id=\"file\">",
                     "        <p class=\"help-block\">",
                     "          Package file will overwrite any previous versions.",
                     "        </p>",
                     "      </div>",
                     "      <button type=\"submit\" class=\"btn btn-default\">Submit</button>",
                     "    </form>",
                     "  </div>",
                     "</div>",
                     "        </div>",
                     "      </div>",
                     "    </div>",
                     "  </body>",
                     "</html>"]

listingHtml = unlines [ "<div class=\"panel panel-default\">",
                        "  ",
                        "  <div class=\"panel-heading\">",
                        "    <div class=\"row\">",
                        "      <div class=\"col-sm-2\">",
                        "        <h4>Package listing</h4>",
                        "      </div>",
                        "      <div class=\"col-sm-4 col-sm-offset-6\">",
                        "        <form class=\"form-inline\">",
                        "          <input type=\"search\" ng-model=\"searchterm\" class=\"form-control\">",
                        "        </form>",
                        "      </div>",
                        "    </div>",
                        "  </div>",
                        "  ",
                        "  <div class=\"panel-body\">",
                        "    <table class=\"table table-striped\">",
                        "      <thead>",
                        "        <th>Package</th>",
                        "        <th>Version</th>",
                        "        <th>Architecture</th>",
                        "      </thead>",
                        "      <tbody>",
                        "        <tr ng-repeat=\"pkg in repolist | filter:searchterm\">",
                        "          <td><a href=\"#repo/{{pkg['Architecture']}}/{{pkg['Package']}}\">{{pkg['Package']}}</a></td>",
                        "          <td>{{pkg['Version']}}</td>",
                        "          <td>{{pkg['Architecture']}}</td>",
                        "        </tr>",
                        "      </tbody>",
                        "    </table>",
                        "  </div>",
                        "</div>" ]

jsApp = unlines [ "var app = angular.module('repo', ['ngRoute']);",
                  "app.controller('Apotiki', function($scope, $routeParams, $location, $http) {",
                  "$scope.repolist = []; $scope.repo = {};",
                  "$scope.refresh = function(){$http.get('/repo').success(function(data){$scope.repo=data;for(var k in data){for (var subk in data[k]){$scope.repolist.push(data[k][subk]);}}});};",
                  "if ($routeParams.name) { $scope.name = $routeParams.name; }",
                  "if ($routeParams.arch) { $scope.arch = $routeParams.arch; }",
                  "$scope.refresh();});",
                  "app.config(function($routeProvider) {",
                  "    $routeProvider",
                  "        .when('/repo', {templateUrl: 'listing.html', controller: 'Apotiki'})",
                  "        .when('/repo/:arch/:name', {templateUrl: 'details.html', controller: 'Apotiki'})",
                  "        .when('/post', {templateUrl: 'post.html'})",
                  "        .otherwise({redirectTo: '/repo'});});" ]
