
-- |
-- Module     : Simulation.Aivika.Results.Locale.Russian
-- Copyright  : Copyright (c) 2009-2017, David Sorokin <david.sorokin@gmail.com>
-- License    : BSD3
-- Maintainer : David Sorokin <david.sorokin@gmail.com>
-- Stability  : experimental
-- Tested with: GHC 8.0.1
--
-- The Russian localisation.
--
module Simulation.Aivika.Results.Locale.Russian
       (russianResultLocalisation) where

import Simulation.Aivika.Results.Locale.Types

-- | The Russian localisation.
russianResultLocalisation :: ResultLocalisation
russianResultLocalisation = ResultLocalisation russianResultDescription russianResultTitle

-- | The Russian localisation of the simulation results.
russianResultDescription :: ResultId -> ResultDescription
russianResultDescription TimeId = "модельное время"
russianResultDescription VectorId = "вектор"
russianResultDescription (VectorItemId x) = "элемент с индексом " ++ x
russianResultDescription SamplingStatsId = "сводная статистика"
russianResultDescription SamplingStatsCountId = "количество"
russianResultDescription SamplingStatsMinId = "минимальное значение"
russianResultDescription SamplingStatsMaxId = "максимальное значение"
russianResultDescription SamplingStatsMeanId = "среднее значение"
russianResultDescription SamplingStatsMean2Id = "среднее квадратов"
russianResultDescription SamplingStatsVarianceId = "дисперсия"
russianResultDescription SamplingStatsDeviationId = "среднеквадратическое отклонение"
russianResultDescription SamplingStatsNormalisedId = "статистика нормализована?"
russianResultDescription TimingStatsId = "временная статистика"
russianResultDescription TimingStatsCountId = "количество"
russianResultDescription TimingStatsMinId = "минимальное значение"
russianResultDescription TimingStatsMaxId = "максимальное значение"
russianResultDescription TimingStatsMeanId = "среднее значение"
russianResultDescription TimingStatsVarianceId = "дисперсия"
russianResultDescription TimingStatsDeviationId = "среднеквадратическое отклонение"
russianResultDescription TimingStatsMinTimeId = "время достижения минимума"
russianResultDescription TimingStatsMaxTimeId = "время достижения максимума"
russianResultDescription TimingStatsStartTimeId = "начальное время сбора статистики"
russianResultDescription TimingStatsLastTimeId = "конечное время сбора статистики"
russianResultDescription TimingStatsSumId = "сумма"
russianResultDescription TimingStatsSum2Id = "сумма квадратов"
russianResultDescription SamplingCounterId = "счетчик"
russianResultDescription SamplingCounterValueId = "текущее значение"
russianResultDescription SamplingCounterStatsId = "статистика"
russianResultDescription TimingCounterId = "временной счетчик"
russianResultDescription TimingCounterValueId = "текущее значение"
russianResultDescription TimingCounterStatsId = "статистика"
russianResultDescription FiniteQueueId = "конечная очередь"
russianResultDescription InfiniteQueueId = "бесконечная очередь"
russianResultDescription EnqueueStrategyId = "стратегия добавления элементов"
russianResultDescription EnqueueStoringStrategyId = "стратегия хранения элементов"
russianResultDescription DequeueStrategyId = "стратегия извлечения элементов"
russianResultDescription QueueNullId = "очередь пуста?"
russianResultDescription QueueFullId = "очередь заполнена?"
russianResultDescription QueueMaxCountId = "емкость очереди"
russianResultDescription QueueCountId = "текущий размер очереди"
russianResultDescription QueueCountStatsId = "статистика по размеру очереди"
russianResultDescription EnqueueCountId = "общее количество попыток добавить элементы"
russianResultDescription EnqueueLostCountId = "общее количество неудачных попыток добавить элементы"
russianResultDescription EnqueueStoreCountId = "общее количество сохраненных элементов"
russianResultDescription DequeueCountId = "общее количество запросов на извлечение элементов"
russianResultDescription DequeueExtractCountId = "общее количество извлеченных элементов"
russianResultDescription QueueLoadFactorId = "коэфф. загрузки (размер, поделенный на емкость)"
russianResultDescription EnqueueRateId = "количество попыток добавить на ед. времени"
russianResultDescription EnqueueStoreRateId = "количество сохраненных на ед. времени"
russianResultDescription DequeueRateId = "количество запросов на извлечение в ед. времени"
russianResultDescription DequeueExtractRateId = "количество извлеченных на ед. времени"
russianResultDescription QueueWaitTimeId = "время ожидания (сохранили -> извлекли)"
russianResultDescription QueueTotalWaitTimeId = "общее время ожидания (попытались добавить -> извлекли)"
russianResultDescription EnqueueWaitTimeId = "время ожидания добавления (попытались добавить -> сохранили)"
russianResultDescription DequeueWaitTimeId = "время ожидания извлечения (запросили извлечь -> извлекли)"
russianResultDescription QueueRateId = "усредненная скорость (как средняя длина очереди на среднее время ожидания)"
russianResultDescription ArrivalTimerId = "как долго обрабатываются заявки?"
russianResultDescription ArrivalProcessingTimeId = "время обработки заявки"
russianResultDescription ServerId = "сервер"
russianResultDescription ServerInitStateId = "начальное состояние"
russianResultDescription ServerStateId = "текущее состояние"
russianResultDescription ServerTotalInputWaitTimeId = "общее время блокировки в ожидании ввода"
russianResultDescription ServerTotalProcessingTimeId = "общее время, потраченное на саму обработку заданий"
russianResultDescription ServerTotalOutputWaitTimeId = "общее время блокировки при попытке доставить вывод"
russianResultDescription ServerTotalPreemptionTimeId = "общее время вытеснения"
russianResultDescription ServerInputWaitTimeId = "время блокировки в ожидании ввода"
russianResultDescription ServerProcessingTimeId = "время, потраченное на саму обработку заданий"
russianResultDescription ServerOutputWaitTimeId = "время блокировки при попытке доставить вывод"
russianResultDescription ServerPreemptionTimeId = "время вытеснения"
russianResultDescription ServerInputWaitFactorId = "относительное время блокировки в ожидании ввода (от 0 до 1)"
russianResultDescription ServerProcessingFactorId = "относительное время, потраченное на саму обработку заданий (от 0 до 1)"
russianResultDescription ServerOutputWaitFactorId = "относительное время блокировки при попытке доставить вывод (от 0 до 1)"
russianResultDescription ServerPreemptionFactorId = "относительное время вытеснения (от 0 до 1)"
russianResultDescription ActivityId = "активность"
russianResultDescription ActivityInitStateId = "начальное состояние"
russianResultDescription ActivityStateId = "текущее состояние"
russianResultDescription ActivityTotalUtilisationTimeId = "общее время использования"
russianResultDescription ActivityTotalIdleTimeId = "общее время простоя"
russianResultDescription ActivityTotalPreemptionTimeId = "общее время вытеснения"
russianResultDescription ActivityUtilisationTimeId = "статистика времени использования"
russianResultDescription ActivityIdleTimeId = "статистика времени простоя"
russianResultDescription ActivityPreemptionTimeId = "статистика времени вытеснения"
russianResultDescription ActivityUtilisationFactorId = "относительное время использования (от 0 до 1)"
russianResultDescription ActivityIdleFactorId = "относительное время простоя (от 0 до 1)"
russianResultDescription ActivityPreemptionFactorId = "относительное время вытеснения (от 0 до 1)"
russianResultDescription ResourceId = "ресурс"
russianResultDescription ResourceCountId = "текущее доступное количество ресурса"
russianResultDescription ResourceCountStatsId = "статистика по доступному количеству ресурса"
russianResultDescription ResourceUtilisationCountId = "текущее используемое количество ресурса"
russianResultDescription ResourceUtilisationCountStatsId = "статистика по используемому количеству ресурса"
russianResultDescription ResourceQueueCountId = "текущая длина очереди к ресурсу"
russianResultDescription ResourceQueueCountStatsId = "статистика длины очереди к ресурсу"
russianResultDescription ResourceTotalWaitTimeId = "общее время ожидания ресурса"
russianResultDescription ResourceWaitTimeId = "время ожидания ресурса"
russianResultDescription OperationId = "операция"
russianResultDescription OperationTotalUtilisationTimeId = "общее время использования"
russianResultDescription OperationTotalPreemptionTimeId = "общее время вытеснения"
russianResultDescription OperationUtilisationTimeId = "статистика времени использования"
russianResultDescription OperationPreemptionTimeId = "статистика времени вытеснения"
russianResultDescription OperationUtilisationFactorId = "относительное время использования (от 0 до 1)"
russianResultDescription OperationPreemptionFactorId = "относительное время вытеснения (от 0 до 1)"
russianResultDescription (UserDefinedResultId m) = userDefinedResultDescription m
russianResultDescription (LocalisedResultId m) =
  lookupResultLocalisation russianResultLocale (localisedResultDescriptions m)

-- | The Russian localisation of titles.
russianResultTitle :: ResultId -> ResultDescription
russianResultTitle TimeId = "время"
russianResultTitle VectorId = "вектор"
russianResultTitle (VectorItemId x) = "элемент с индексом " ++ x
russianResultTitle SamplingStatsId = "статистика"
russianResultTitle SamplingStatsCountId = "количество"
russianResultTitle SamplingStatsMinId = "минимум"
russianResultTitle SamplingStatsMaxId = "максимум"
russianResultTitle SamplingStatsMeanId = "среднее"
russianResultTitle SamplingStatsMean2Id = "среднее квадратов"
russianResultTitle SamplingStatsVarianceId = "дисперсия"
russianResultTitle SamplingStatsDeviationId = "отклонение"
russianResultTitle SamplingStatsNormalisedId = "нормализована?"
russianResultTitle TimingStatsId = "временная статистика"
russianResultTitle TimingStatsCountId = "количество"
russianResultTitle TimingStatsMinId = "минимум"
russianResultTitle TimingStatsMaxId = "максимум"
russianResultTitle TimingStatsMeanId = "среднее"
russianResultTitle TimingStatsVarianceId = "дисперсия"
russianResultTitle TimingStatsDeviationId = "отклонение"
russianResultTitle TimingStatsMinTimeId = "время достижения минимума"
russianResultTitle TimingStatsMaxTimeId = "время достижения максимума"
russianResultTitle TimingStatsStartTimeId = "начальное время сбора статистики"
russianResultTitle TimingStatsLastTimeId = "конечное время сбора статистики"
russianResultTitle TimingStatsSumId = "сумма"
russianResultTitle TimingStatsSum2Id = "сумма квадратов"
russianResultTitle SamplingCounterId = "счетчик"
russianResultTitle SamplingCounterValueId = "текущее значение"
russianResultTitle SamplingCounterStatsId = "статистика"
russianResultTitle TimingCounterId = "временной счетчик"
russianResultTitle TimingCounterValueId = "текущее значение"
russianResultTitle TimingCounterStatsId = "статистика"
russianResultTitle FiniteQueueId = "конечная очередь"
russianResultTitle InfiniteQueueId = "бесконечная очередь"
russianResultTitle EnqueueStrategyId = "стратегия добавления элементов"
russianResultTitle EnqueueStoringStrategyId = "стратегия хранения элементов"
russianResultTitle DequeueStrategyId = "стратегия извлечения элементов"
russianResultTitle QueueNullId = "очередь пуста?"
russianResultTitle QueueFullId = "очередь заполнена?"
russianResultTitle QueueMaxCountId = "емкость очереди"
russianResultTitle QueueCountId = "длина очереди"
russianResultTitle QueueCountStatsId = "статистика по длине очереди"
russianResultTitle EnqueueCountId = "кол-во попыток добавить"
russianResultTitle EnqueueLostCountId = "кол-во неудачных попыток добавить"
russianResultTitle EnqueueStoreCountId = "кол-во сохраненных"
russianResultTitle DequeueCountId = "кол-во запросов на извлечение"
russianResultTitle DequeueExtractCountId = "кол-во извлеченных"
russianResultTitle QueueLoadFactorId = "коэфф. загрузки"
russianResultTitle EnqueueRateId = "кол-во попыток добавить на ед. времени"
russianResultTitle EnqueueStoreRateId = "кол-во сохраненных на ед. времени"
russianResultTitle DequeueRateId = "кол-во запросов на извлечение в ед. времени"
russianResultTitle DequeueExtractRateId = "кол-во извлеченных на ед. времени"
russianResultTitle QueueWaitTimeId = "время ожидания"
russianResultTitle QueueTotalWaitTimeId = "общее время ожидания"
russianResultTitle EnqueueWaitTimeId = "время ожидания добавления"
russianResultTitle DequeueWaitTimeId = "время ожидания извлечения"
russianResultTitle QueueRateId = "усредненная скорость"
russianResultTitle ArrivalTimerId = "измеряет время обработки заявки"
russianResultTitle ArrivalProcessingTimeId = "время обработки заявки"
russianResultTitle ServerId = "сервер"
russianResultTitle ServerInitStateId = "начальное состояние"
russianResultTitle ServerStateId = "текущее состояние"
russianResultTitle ServerTotalInputWaitTimeId = "общее время ожидания ввода"
russianResultTitle ServerTotalProcessingTimeId = "общее время обработки"
russianResultTitle ServerTotalOutputWaitTimeId = "общее время ожидания вывода"
russianResultTitle ServerTotalPreemptionTimeId = "общее время вытеснения"
russianResultTitle ServerInputWaitTimeId = "время ожидания ввода"
russianResultTitle ServerProcessingTimeId = "время обработки"
russianResultTitle ServerOutputWaitTimeId = "время ожидания вывода"
russianResultTitle ServerPreemptionTimeId = "время вытеснения"
russianResultTitle ServerInputWaitFactorId = "относит. время ожидания ввода"
russianResultTitle ServerProcessingFactorId = "относит. время обработки"
russianResultTitle ServerOutputWaitFactorId = "относит. время ожидания вывода"
russianResultTitle ServerPreemptionFactorId = "относит. время вытеснения"
russianResultTitle ActivityId = "активность"
russianResultTitle ActivityInitStateId = "начальное состояние"
russianResultTitle ActivityStateId = "текущее состояние"
russianResultTitle ActivityTotalUtilisationTimeId = "общее время использования"
russianResultTitle ActivityTotalIdleTimeId = "общее время простоя"
russianResultTitle ActivityTotalPreemptionTimeId = "общее время вытеснения"
russianResultTitle ActivityUtilisationTimeId = "время использования"
russianResultTitle ActivityIdleTimeId = "время простоя"
russianResultTitle ActivityPreemptionTimeId = "время вытеснения"
russianResultTitle ActivityUtilisationFactorId = "относит. время использования"
russianResultTitle ActivityIdleFactorId = "относит. время простоя"
russianResultTitle ActivityPreemptionFactorId = "относит. время вытеснения"
russianResultTitle ResourceId = "ресурс"
russianResultTitle ResourceCountId = "текущее кол-во"
russianResultTitle ResourceCountStatsId = "стат. по кол-ву"
russianResultTitle ResourceUtilisationCountId = "текущее используемое кол-во"
russianResultTitle ResourceUtilisationCountStatsId = "стат. по используемому кол-ву"
russianResultTitle ResourceQueueCountId = "текущая длина очереди"
russianResultTitle ResourceQueueCountStatsId = "стат. длины очереди"
russianResultTitle ResourceTotalWaitTimeId = "общее время ожидания"
russianResultTitle ResourceWaitTimeId = "время ожидания"
russianResultTitle OperationId = "операция"
russianResultTitle OperationTotalUtilisationTimeId = "общее время использования"
russianResultTitle OperationTotalPreemptionTimeId = "общее время вытеснения"
russianResultTitle OperationUtilisationTimeId = "стат. времени использования"
russianResultTitle OperationPreemptionTimeId = "стат. времени вытеснения"
russianResultTitle OperationUtilisationFactorId = "относит. время использования"
russianResultTitle OperationPreemptionFactorId = "относит. время вытеснения"
russianResultTitle (UserDefinedResultId m) = userDefinedResultTitle m
russianResultTitle (LocalisedResultId m) =
  lookupResultLocalisation russianResultLocale (localisedResultTitles m)
