{-# LANGUAGE FlexibleContexts #-}
module Villefort.Log (genStats) where

import Control.Monad.Reader
import Villefort.Definitions
import Villefort.Database
import Villefort.Util
import Paths_Villefort
import System.Random

-- | Generate stats
genStats :: (MonadReader VConfig m, MonadIO m) => m String
genStats = do
  subjects <- getSubjects
  gits <- mapM makeGithub subjects 
  avg <- getAvg
  statsSum <- getSum
  x <- liftIO $ getDataFileName "templates/header"
  header <- liftIO (readFile x)
  return (header ++ table ++ (makeTable ["Subject","time"] avg) ++ "</br> <h1> Sum </h1>" ++ (makeTable ["Subject","time"] statsSum) ++ "</html>" ++ (mconcat gits))




getAvg :: (MonadReader VConfig m, MonadIO m) => m [[String]]
getAvg =  makeQuery "select avg(time), Subject from todo  group by Subject order by avg(time) desc"

getSum :: (MonadReader VConfig m, MonadIO m) => m [[String]]
getSum =  makeQuery "select sum(time), Subject from todo group by Subject order by sum(time) desc"

  
-- | Library to include for github table
table :: String
table = " <script src='templates/js.js'></script><h1> avg </h1>"

-- | creates the github like graph from database

--makeGithub ::(MonadReader VConfig m, MonadIO m) =>  String ->  m Subject
makeGithub subject = do
  z <-   makeQuery ("select substr(Due,1,10) from todo where subject = '" ++ (clean subject) ++ "' and state = 0") 
  color <- liftIO $  getColor 
  let header = "<h2 id='"++ subject ++ "'> Calendar "++ subject ++ " </h2> <script> new Calendar({ append_to: '" ++ subject ++ "',num_weeks: 51,day_size: 11, data: ["
  let q = Prelude.map (\x -> "['" ++ (x !! 0) ++"',500],") z
  let bot = "  ], color: " ++ color ++ " }); </script>"
  return (header ++ (Prelude.concat q )++  bot)

statsColors :: [String]
statsColors = ["'#F44336'"
         ,"'#E91E63'"
         ,"'#9C27B0'"
         ,"'#673AB7'"
         ,"'#3F51B5'"
         ,"'#2196F3'"
         ,"'#03A9F4'"
         ,"'#00BCD4'"
         ,"'#009688'"
         ,"'#4CAF50'"
         ,"'#8BC34A'"
         ,"'#CDDC39'"
         ,"'#FFEB3B'"
         ,"'#FFC107'"
         ,"'#FF9800'"
         ,"'#FF5722'"
         ,"'#795548'"
         ,"'#9E9E9E'"
         ,"'#607D8B'"
         ]


getColor :: IO String
getColor = do
  number <- randomRIO (0, (length $ statsColors)-1) :: IO Int
  return (statsColors !! number)
  

getSummary :: (MonadReader VConfig m, MonadIO m) => m String
getSummary = do
  dat <- getDone
  header <-  getHeader
  return ( header ++ (makeTable ["Subject","Time"] $ dat ++ [["Total", show$  total dat]]))
