import Test.Hspec
import System.Exit (exitFailure)
import Control.Concurrent
import Control.Monad.Reader
import Villefort
import Villefort.Config
import Villefort.Definitions
import Villefort.Database
import Villefort
import Villefort.Server
import Villefort.Todo
import Database.HDBC.Sqlite3
import Database.HDBC hiding (run)
import Test.QuickCheck.Monadic
import Test.QuickCheck
import Test.WebDriver

main :: IO ()
main = do
  forkIO (villefort def {port = 999,noCustom = True})
  runSession  defaultConfig $ openPage "localhost:999"

  {-
  hspec $ do
    describe "databse" $ do
      it "does" $ do
        quickCheckWith args prop_insert
-}

insertTest   title des due sub= do
  recreate
  runReaderT (addTask des title due sub) test
  runReaderT qetTasks' test

args = stdArgs {
  maxSuccess = 1000
  }
  
prop_insert titl des du su= monadicIO $ do
  row <- run $  insertTest titl des du su
  assert ((row !! 0) == Row {
             rid=2,
             title=titl,
             description=des,
             due=du,
             subject=su,
             time = 0,
             Villefort.Todo.pred = 0.0})
           
 
test = def {
  database = "test/test.db"
           }

recreate :: IO ()
recreate = do
  runReaderT (execQuery "delete from todo" "") test
  runReaderT (execQuery "insert into todo (id) Values (1)" "") test
