{-# LANGUAGE FlexibleContexts #-}
module Villefort.Util where

import Control.Monad.Reader
import Villefort.Definitions
import Paths_Villefort
import Data.List

getHeader :: (MonadReader VConfig m, MonadIO m) => m String
getHeader = do
  headerPath <- liftIO $ getDataFileName "templates/header"
  liftIO $ readFile headerPath


-- | Helper function to generate row of table
makeRow :: [String] -> String
makeRow x =  "<tr> <th>" ++ (intercalate "</th> <th>  "  x )++ "</th> </tr>"

-- | Generate Table
makeTable ::[String] ->  [[String]] -> String
makeTable tableData stats = "<table class='table' style='width:100%'> "  ++ "<thead class='thead-inverse'>" ++ ( makeRow  tableData) ++ "</thead>" ++ (mconcat (map  makeRow stats)) ++  "</table>"



total :: [[String]] -> Int
total row = sum $ map (\x -> read $ x !! 1 :: Int) row
