{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE FlexibleContexts #-}
module Villefort.New where

import Control.Monad.Reader
import Villefort.Definitions
import System.IO.Strict as S
import Paths_Villefort
import Data.List.Split
import Villefort.Database


makeNewPage :: (MonadReader VConfig m, MonadIO m) => m String
makeNewPage = do
  headerPath <-liftIO $  getDataFileName "templates/header"
  htmlHeader <- liftIO $ S.readFile headerPath
  addPath <- liftIO $ getDataFileName "templates/add.html"
  add <- liftIO $ S.readFile addPath
  let splitWeeks = splitOn "?" add
  subjects <- getSubjects
  let radiobuttons =  map makeRadio subjects
  return (htmlHeader ++ (splitWeeks !! 0) ++ (concat radiobuttons) ++ (splitWeeks !! 1))


-- | makes html for radiobutton
makeRadio :: String -> String
makeRadio x =  "<dd><input type='radio' name='subject' value='"++ x ++ "'> " ++ x ++ "</br> \n"
