module Villefort.Config  where

import Villefort.Definitions

-- | Default configuration of VConfig
def :: VConfig
def = VConfig {
  daily = [return []], --daily tasks
  monthly =[[]], -- not implemented
  yearly =[[]], --  not implemented
  weekly = defWeekly, -- tasks to run on a given week day
  port = 3002, -- port
  noCustom = False, -- flag for debugging stops launching custom executable
  showDatabase = False, -- optionally prints database
  colors = defColors, -- Colors to use first is closest task
  database = [] -- flag for debugging sets database path
              }
-- | Default weekly schedule by default is empty
defWeekly :: Weekly
defWeekly = Weekly {
  monday = [return []],
  tuesday =[return[]],
  wednesday = [return[]],
  thursday = [return[]],
  friday  = [return[]],
  saturday = [return[]],
  sunday  = [return []]
                   }
-- | Default colors for Villefort
defColors :: [String]
defColors = ["#0d47a1","#1565c0","#1976d2","#1e88e5","#2196f3","#42a5f5","#64b5f6","#90caf9"]
