# Villefort
Villefort is a time managment system written in Haskell.

## Version 1.2.11
- Integrated date and day tracking into database to stop file corruption.

[default config](https://github.com/alicereuter/Villefort/blob/master/src/Villefort/Config.hs)

# Home screen
![alt text](https://raw.githubusercontent.com/alicereuter/Villefort/master/data/screen.png)
# Add new todos
![alt text](https://raw.githubusercontent.com/alicereuter/Villefort/master/data/screen01.png)
# Stats page 

![alt text](https://raw.githubusercontent.com/alicereuter/Villefort/master/data/screen02.png)

# To install 
1. Install cabal (https://www.haskell.org/platform/)
2. In terminal or command prompt run `cabal install Villefort`.
3. and then `cabal run Villefort`.
4. You will be able to see the homescreen by typing localhost:3002 into your favorite browser.

## Configure your villefort
create a custom main method in ~.villefort/villefort.hs. Below is an example.


```haskell
module Main where

import Villefort
import Villefort.Definitions
import System.Random
import System.IO.Strict as S

main :: IO ()
main = villefort def {
  daily = [xcalendar ],
  weekly = defWeekly {
    monday = [moref],
    wednesday = [more],
    friday = [more,
              scan]
 
    },
    showDatabase = True
 }

calendar = pure ["","check calendar","admin"]
scan     = pure ["scan class notes","scan","admin"] 

path = "/home/chris/.villefort/push"
more = do
  z <- S.readFile path   -- readfile to get # push ups
  let num = read z :: Double
  writeFile path (show (num+0.3))
  sets <- pushUps num
  return $ [show sets,"push ups","fit"]

pushUps level = do
  dubs <-  mapM gen $ replicate 5 level :: IO [Double]
  return $ map floor dubs
  where gen x =  randomRIO (x-(x/3),x+(x/3))
 
```

Then run ```Villefort --recompile```
the next time you run villefort it will run with your configuration. The default Config is found in Villefort.Config.

## How to copy data between versions of Villefort.
1. Install the new version through cabal.
2. Navigate to ~/.cabal .
3. Navigate to share/ .
4. Navigate into your architecture folder mine is x86_64-linux-ghc-7.10.3.
5. You should now see different versions of Villefort.

Villefort-0.1.1.0/
```
    |-- data/
    |   |-- date
    |   |-- day
    |   |-- todo.db
    |-- templates/
    |-- js.js
```
Villefort-0.1.1.1/
```
	|-- data/
	|   |-- date
	|   |-- day
	|   |-- todo.db
	|-- templates/
	|-- js.js
```
Just copy the data/todo.db from the old version into data/todo.db of the new version.
Remember to rebuild Villefort if you have a custom build to rebuild with the new version.

    Villefort --recompile

