module Command
where

import FRP.Yampa

data Command =
      CmdQuit
    | CmdNewGame
    | CmdFreeze
    | CmdResume
    | CmdPassHigh   {dt :: Time}
    | CmdPassLow    {dt :: Time}
    | CmdKickHigh   {dt :: Time}
    | CmdKickLow    {dt :: Time}
    | CmdToggleFoot
    | CmdTakeOver
    | CmdFlipHigh
    | CmdFlipLow
    | CmdMoveForward
    | CmdMoveBackward
    | CmdMoveLeft
    | CmdMoveRight
    | CmdMoveToGoal
    | CmdMoveToMe
    | CmdFlipMeHigh
    | CmdFlipMeLow
 deriving (Show, Eq, Ord)

cmdQuit :: [Command] -> Bool
cmdQuit        [] = False; cmdQuit (c:cs) = case c of CmdQuit -> True ; _ -> cmdQuit cs
cmdFreeze :: [Command] -> Bool
cmdFreeze      [] = False; cmdFreeze (c:cs) = case c of CmdFreeze -> True ; _ -> cmdFreeze cs
cmdToggleFoot :: [Command] -> Bool
cmdToggleFoot  [] = False; cmdToggleFoot (c:cs) = case c of CmdToggleFoot -> True ; _ -> cmdToggleFoot cs
cmdTakeOver :: [Command] -> Bool
cmdTakeOver    [] = False; cmdTakeOver (c:cs) = case c of CmdTakeOver -> True ; _ -> cmdTakeOver cs
cmdMoveForward :: [Command] -> Bool
cmdMoveForward [] = False; cmdMoveForward (c:cs) = case c of CmdMoveForward -> True ; _ -> cmdMoveForward cs
cmdMoveBackward :: [Command] -> Bool
cmdMoveBackward [] = False; cmdMoveBackward (c:cs) = case c of CmdMoveBackward -> True ; _ -> cmdMoveBackward cs
cmdMoveLeft :: [Command] -> Bool
cmdMoveLeft [] = False; cmdMoveLeft (c:cs) = case c of CmdMoveLeft -> True ; _ -> cmdMoveLeft cs
cmdMoveRight :: [Command] -> Bool
cmdMoveRight [] = False; cmdMoveRight (c:cs) = case c of CmdMoveRight -> True ; _ -> cmdMoveRight cs
cmdMoveToGoal :: [Command] -> Bool
cmdMoveToGoal [] = False; cmdMoveToGoal (c:cs) = case c of CmdMoveToGoal -> True ; _ -> cmdMoveToGoal cs
cmdMoveToMe :: [Command] -> Bool
cmdMoveToMe [] = False; cmdMoveToMe (c:cs) = case c of CmdMoveToMe -> True ; _ -> cmdMoveToMe cs
cmdFlipMeLow :: [Command] -> Bool
cmdFlipMeLow [] = False; cmdFlipMeLow (c:cs) = case c of CmdFlipMeLow -> True ; _ -> cmdFlipMeLow cs
cmdFlipMeHigh :: [Command] -> Bool
cmdFlipMeHigh [] = False; cmdFlipMeHigh (c:cs) = case c of CmdFlipMeHigh -> True ; _ -> cmdFlipMeHigh cs
