module AL

where

import Data.List hiding ((!!))
import Data.Maybe

data AL k a = AL [(k, a)]
instance Functor (AL k) where fmap f (AL xs) = AL $ map (\(k, a) -> (k, f a)) xs
instance (Show k, Show a) => Show (AL k a) where
    show (AL xs) = "AL " ++ show xs

mapAL :: ((k, a) -> b) -> AL k a -> AL k b
mapAL f (AL kas) =
    AL [(k, f ka) | ka@(k,_) <- kas]

filterAL :: (a -> Bool) -> AL k a -> AL k a
filterAL p (AL kas) = AL $ filter (p . snd) kas

elemsAL :: AL a b -> [b]
elemsAL (AL xs) = map snd xs

(!) :: (Eq k) => AL k a -> k -> a
(AL l) ! k = snd . fromJust $ find (\(k', _) -> k == k') l

at :: AL k a -> Int -> (k, a)
(AL l) `at` 0 = head l
(AL l) `at` n = (AL (tail l)) `at` (n-1)

lookupAL :: (Eq a) => a -> AL a b -> Maybe b
lookupAL x (AL xs) = lookup x xs

emptyAL :: AL k a
emptyAL = AL []

assocsAL :: AL t t1 -> [(t, t1)]
assocsAL (AL l) = l
fromAssocs :: [(k, a)] -> AL k a
fromAssocs l = AL l

insertAL :: k -> a -> AL k a -> AL k a
insertAL k a (AL al) = AL ((k,a):al)

deleteAL :: (Eq k) => k -> AL k a -> AL k a
deleteAL k (AL kas) =
    AL (deleteHlp kas)
    where
	deleteHlp []                 = []
        deleteHlp (ka@(k', _) : kas') | k == k'   = kas'
                                      | otherwise = ka : deleteHlp kas'


appendAL :: AL k a -> AL k a -> AL k a
appendAL (AL xs) (AL ys) = AL $ xs ++ ys

-- collectAL :: (Eq a) => AL a b -> AL a [b]
-- collectAL (AL xs) = AL (collect xs)

mergeAL :: (Eq k) => (AL k a) -> (AL k b) -> [(k,a,b)]
mergeAL (AL []) _ = []
mergeAL (AL ((k,x):xs)) ys = (k,x,ys ! k) : mergeAL (AL xs) ys

--mergeAL (AL [(1,100),(2,100)]) (AL [(2,20),(1,10)])
